/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.display.UADHierarchyDisplay;
import com.liferay.user.associated.data.web.internal.portlet.action.BaseUADMVCActionCommand;
import com.liferay.user.associated.data.web.internal.util.UADAnonymizerHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/anonymize_uad_entities"}, service={MVCActionCommand.class})
public class AnonymizeUADEntitiesMVCActionCommand
extends BaseUADMVCActionCommand {
    @Reference
    private UADAnonymizerHelper _uadAnonymizerHelper;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        User selectedUser = this.getSelectedUser(actionRequest);
        User anonymousUser = this._uadAnonymizerHelper.getAnonymousUser(selectedUser.getCompanyId());
        String applicationKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"applicationKey");
        UADHierarchyDisplay uadHierarchyDisplay = this.uadRegistry.getUADHierarchyDisplay(applicationKey);
        for (String entityType : this.getEntityTypes(actionRequest)) {
            String[] primaryKeys = this.getPrimaryKeys(actionRequest, entityType);
            UADAnonymizer entityUADAnonymizer = this.getUADAnonymizer(actionRequest, entityType);
            UADDisplay entityUADDisplay = this.getUADDisplay(actionRequest, entityType);
            for (String primaryKey : primaryKeys) {
                this._anonymize(anonymousUser, entityUADAnonymizer, entityUADDisplay, primaryKey, selectedUser.getUserId(), uadHierarchyDisplay);
            }
        }
        this.doReviewableRedirect(actionRequest, actionResponse);
    }

    private void _anonymize(User anonymousUser, UADAnonymizer entityUADAnonymizer, UADDisplay<?> entityUADDisplay, String primaryKey, long selectedUserId, UADHierarchyDisplay uadHierarchyDisplay) throws Exception {
        Object entity = entityUADDisplay.get((Serializable)((Object)primaryKey));
        if (uadHierarchyDisplay != null) {
            if (uadHierarchyDisplay.isUserOwned(entity, selectedUserId)) {
                entityUADAnonymizer.autoAnonymize(entity, selectedUserId, anonymousUser);
            }
            Map<Class<?>, List<Serializable>> containerItemPKsMap = uadHierarchyDisplay.getContainerItemPKsMap(entityUADDisplay.getTypeClass(), uadHierarchyDisplay.getPrimaryKey(entity), selectedUserId);
            for (Map.Entry<Class<?>, List<Serializable>> entry : containerItemPKsMap.entrySet()) {
                Class<?> containerItemClass = entry.getKey();
                UADAnonymizer containerItemUADAnonymizer = this.uadRegistry.getUADAnonymizer(containerItemClass.getName());
                UADDisplay containerItemUADDisplay = this.uadRegistry.getUADDisplay(containerItemClass.getName());
                this.doMultipleAction(entry.getValue(), (UnsafeConsumer<Serializable, Exception>)((UnsafeConsumer)containerItemPK -> {
                    Object containerItem = containerItemUADDisplay.get(containerItemPK);
                    containerItemUADAnonymizer.autoAnonymize(containerItem, selectedUserId, anonymousUser);
                }));
            }
        } else {
            entityUADAnonymizer.autoAnonymize(entity, selectedUserId, anonymousUser);
        }
    }
}

