/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.portlet.action.BaseUADMVCActionCommand;
import com.liferay.user.associated.data.web.internal.util.UADAnonymizerHelper;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/anonymize_uad_applications"}, service={MVCActionCommand.class})
public class AnonymizeUADApplicationsMVCActionCommand
extends BaseUADMVCActionCommand {
    @Reference
    private UADAnonymizerHelper _uadAnonymizerHelper;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        User selectedUser = this.getSelectedUser(actionRequest);
        User anonymousUser = this._uadAnonymizerHelper.getAnonymousUser(selectedUser.getCompanyId());
        long[] groupIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"groupIds");
        for (String applicationKey : this.getApplicationKeys(actionRequest)) {
            for (UADDisplay uadDisplay : this.uadRegistry.getApplicationUADDisplays(applicationKey)) {
                Class typeClass = uadDisplay.getTypeClass();
                UADAnonymizer uadAnonymizer = this.uadRegistry.getUADAnonymizer(typeClass.getName());
                List entities = uadDisplay.search(selectedUser.getUserId(), groupIds, null, null, null, -1, -1);
                for (Object entity : entities) {
                    uadAnonymizer.autoAnonymize(entity, selectedUser.getUserId(), anonymousUser);
                }
            }
        }
        this.doReviewableRedirect(actionRequest, actionResponse);
    }
}

