/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.web.internal.display.UADApplicationSummaryDisplay;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import com.liferay.user.associated.data.web.internal.util.UADLanguageUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/anonymize_nonreviewable_uad_data"}, service={MVCRenderCommand.class})
public class AnonymizeNonreviewableUADDataMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private Portal _portal;
    @Reference
    private UADRegistry _uadRegistry;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            User selectedUser = this._portal.getSelectedUser((PortletRequest)renderRequest);
            SearchContainer<UADApplicationSummaryDisplay> searchContainer = this._createSearchContainer(LocaleThreadLocal.getThemeDisplayLocale(), renderRequest, selectedUser.getUserId());
            int totalCount = 0;
            for (UADApplicationSummaryDisplay uadApplicationSummaryDisplay : searchContainer.getResults()) {
                totalCount += uadApplicationSummaryDisplay.getCount();
            }
            renderRequest.setAttribute("TOTAL_UAD_ENTITIES_COUNT", (Object)totalCount);
            renderRequest.setAttribute("SEARCH_CONTAINER", searchContainer);
        }
        catch (PortalException pe) {
            throw new PortletException((Throwable)pe);
        }
        return "/anonymize_nonreviewable_uad_data.jsp";
    }

    private SearchContainer<UADApplicationSummaryDisplay> _createSearchContainer(Locale locale, RenderRequest renderRequest, long userId) throws PortalException {
        PortletRequest portletRequest = (PortletRequest)renderRequest.getAttribute("javax.portlet.request");
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)renderRequest.getAttribute("javax.portlet.response"));
        PortletURL currentURL = PortletURLUtil.getCurrent((LiferayPortletRequest)this._portal.getLiferayPortletRequest(portletRequest), (LiferayPortletResponse)liferayPortletResponse);
        SearchContainer searchContainer = new SearchContainer(portletRequest, currentURL, null, null);
        searchContainer.setEmptyResultsMessage("there-are-no-remaining-applications-to-anonymize");
        searchContainer.setId("uadApplicationSummaryDisplays");
        searchContainer.setOrderByCol(ParamUtil.getString((PortletRequest)renderRequest, (String)"orderByCol", (String)"name"));
        searchContainer.setOrderByType(ParamUtil.getString((PortletRequest)renderRequest, (String)"orderByType", (String)"asc"));
        List<UADApplicationSummaryDisplay> uadApplicationSummaryDisplays = this._getUADApplicationSummaryDisplays(userId);
        Supplier<Stream> streamSupplier = () -> {
            Stream stream = uadApplicationSummaryDisplays.stream();
            return stream.filter(display -> display.getCount() > 0);
        };
        Stream summaryDisplayStream = streamSupplier.get();
        List results = summaryDisplayStream.sorted(this._getComparator(locale, searchContainer.getOrderByCol(), searchContainer.getOrderByType())).skip(searchContainer.getStart()).limit(searchContainer.getDelta()).collect(Collectors.toList());
        searchContainer.setResults(results);
        summaryDisplayStream = streamSupplier.get();
        searchContainer.setTotal((int)summaryDisplayStream.count());
        return searchContainer;
    }

    private Comparator<UADApplicationSummaryDisplay> _getComparator(Locale locale, String orderByColumn, String orderByType) {
        Comparator<UADApplicationSummaryDisplay> comparator = Comparator.comparing(uadApplicationSummaryDisplay -> UADLanguageUtil.getApplicationName(uadApplicationSummaryDisplay.getApplicationKey(), locale));
        if (orderByColumn.equals("items") || orderByColumn.equals("status")) {
            comparator = Comparator.comparingInt(UADApplicationSummaryDisplay::getCount);
        }
        if (orderByType.equals("desc")) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    private UADApplicationSummaryDisplay _getUADApplicationSummaryDisplay(String applicationKey, long userId) throws PortalException {
        UADApplicationSummaryDisplay uadApplicationSummaryDisplay = new UADApplicationSummaryDisplay();
        List<UADAnonymizer> nonreviewableApplicationUADAnonymizers = this._uadRegistry.getNonreviewableApplicationUADAnonymizers(applicationKey);
        int count = 0;
        for (UADAnonymizer uadAnonymizer : nonreviewableApplicationUADAnonymizers) {
            count = (int)((long)count + uadAnonymizer.count(userId));
        }
        uadApplicationSummaryDisplay.setCount(count);
        uadApplicationSummaryDisplay.setApplicationKey(applicationKey);
        return uadApplicationSummaryDisplay;
    }

    private List<UADApplicationSummaryDisplay> _getUADApplicationSummaryDisplays(long userId) throws PortalException {
        ArrayList<UADApplicationSummaryDisplay> uadApplicationSummaryDisplays = new ArrayList<UADApplicationSummaryDisplay>();
        Set<String> applicationUADAnonymizerKeySet = this._uadRegistry.getApplicationUADAnonymizersKeySet();
        for (String applicationKey : applicationUADAnonymizerKeySet) {
            uadApplicationSummaryDisplays.add(this._getUADApplicationSummaryDisplay(applicationKey, userId));
        }
        uadApplicationSummaryDisplays.sort((uadApplicationSummaryDisplay, uadApplicationSummaryDisplay2) -> {
            String applicationKey1 = uadApplicationSummaryDisplay.getApplicationKey();
            return applicationKey1.compareTo(uadApplicationSummaryDisplay2.getApplicationKey());
        });
        return uadApplicationSummaryDisplays;
    }
}

