/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.export.controller;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.user.associated.data.component.UADComponent;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.exporter.UADExporter;
import com.liferay.user.associated.data.web.internal.export.background.task.UADExportBackgroundTaskStatusMessageSender;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UADApplicationExportController.class})
public class UADApplicationExportController {
    @Reference
    private UADExportBackgroundTaskStatusMessageSender _uadExportBackgroundTaskStatusMessageSender;
    @Reference
    private UADRegistry _uadRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public File export(String applicationKey, long userId) throws Exception {
        this._uadExportBackgroundTaskStatusMessageSender.sendStatusMessage("application", applicationKey, this._getApplicationDataCount(applicationKey, userId));
        return this._exportApplicationData(applicationKey, userId);
    }

    private File _exportApplicationData(String applicationKey, long userId) throws PortalException {
        ZipWriter zipWriter = this._getZipWriter(applicationKey, userId);
        for (String uadRegistryKey : this._getApplicationUADEntityRegistryKeys(applicationKey)) {
            UADExporter uadExporter = this._uadRegistry.getUADExporter(uadRegistryKey);
            File file = uadExporter.exportAll(userId);
            if (!file.exists()) continue;
            try {
                ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
                List entries = zipReader.getEntries();
                for (String entry : entries) {
                    zipWriter.addEntry(this._getEntryPath(applicationKey, uadRegistryKey, entry), zipReader.getEntryAsInputStream(entry));
                    this._uadExportBackgroundTaskStatusMessageSender.sendStatusMessage("entity", uadRegistryKey);
                }
            }
            catch (IOException ioe) {
                throw new PortalException((Throwable)ioe);
            }
        }
        return zipWriter.getFile();
    }

    private long _getApplicationDataCount(String applicationKey, long userId) throws PortalException {
        long totalCount = 0L;
        for (String uadRegistryKey : this._getApplicationUADEntityRegistryKeys(applicationKey)) {
            UADExporter uadExporter = this._uadRegistry.getUADExporter(uadRegistryKey);
            totalCount += uadExporter.getExportDataCount(userId);
        }
        return totalCount;
    }

    private List<String> _getApplicationUADEntityRegistryKeys(String applicationKey) {
        Stream<UADDisplay> uadDisplayStream = this._uadRegistry.getApplicationUADDisplayStream(applicationKey);
        return uadDisplayStream.map(UADComponent::getTypeClass).map(Class::getName).collect(Collectors.toList());
    }

    private String _getEntryPath(String applicationKey, String uadRegistryKey, String fileName) {
        StringBundler sb = new StringBundler(5);
        sb.append(applicationKey);
        sb.append("/");
        sb.append(uadRegistryKey);
        sb.append("/");
        sb.append(fileName);
        return sb.toString();
    }

    private ZipWriter _getZipWriter(String applicationKey, long userId) {
        User user = this._userLocalService.fetchUser(userId);
        StringBundler sb = new StringBundler(8);
        sb.append("UAD");
        sb.append("_");
        if (user != null) {
            sb.append(HtmlUtil.escape((String)user.getFullName()));
        } else {
            sb.append(userId);
        }
        sb.append("_");
        sb.append(applicationKey);
        sb.append("_");
        sb.append(Time.getShortTimestamp());
        sb.append(".zip");
        String fileName = sb.toString();
        return ZipWriterFactoryUtil.getZipWriter((File)new File(SystemProperties.get((String)"java.io.tmpdir") + "/" + fileName));
    }
}

