/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.util;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfiguration;
import com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfigurationRetriever;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Optional;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UADAnonymizerHelper.class})
public class UADAnonymizerHelper {
    @Reference
    private AnonymousUserConfigurationRetriever _anonymousUserConfigurationRetriever;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public User getAnonymousUser() throws Exception {
        return this._getAnonymousUser(CompanyThreadLocal.getCompanyId());
    }

    public User getAnonymousUser(long companyId) throws Exception {
        return this._getAnonymousUser(companyId);
    }

    public boolean isAnonymousUser(User user) {
        try {
            User anonymousUser = this.getAnonymousUser(user.getCompanyId());
            return user.getUserId() == anonymousUser.getUserId();
        }
        catch (Exception e) {
            return false;
        }
    }

    private User _createAnonymousUser(long companyId) throws Exception {
        long creatorUserId = 0L;
        String password = StringUtil.randomString();
        boolean autoPassword = false;
        String password1 = password;
        String password2 = password;
        boolean autoScreenName = false;
        long counter = this._counterLocalService.increment(UADAnonymizerHelper.class.getName());
        String screenName = StringBundler.concat((Object[])new Object[]{"Anonymous", companyId, "_", counter});
        Company company = this._companyLocalService.getCompany(companyId);
        String emailAddress = StringBundler.concat((String[])new String[]{screenName, "@", company.getMx()});
        long facebookId = 0L;
        String openId = "";
        Locale locale = LocaleThreadLocal.getDefaultLocale();
        String firstName = "Anonymous";
        String middleName = "";
        String lastName = "Anonymous";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = null;
        User anonymousUser = this._userLocalService.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        anonymousUser.setComments(StringBundler.concat((String[])new String[]{"This user is automatically created by the UAD application. ", "Application data anonymized by Personal Data Erasure will be ", "assigned to this user."}));
        this._userLocalService.updateUser(anonymousUser);
        this._userLocalService.updateStatus(anonymousUser.getUserId(), 5, new ServiceContext());
        return anonymousUser;
    }

    private User _getAnonymousUser(long companyId) throws Exception {
        Optional<Configuration> configurationOptional = this._anonymousUserConfigurationRetriever.getOptional(companyId);
        if (!configurationOptional.isPresent()) {
            User anonymousUser = this._createAnonymousUser(companyId);
            Configuration configuration = this._configurationAdmin.createFactoryConfiguration(AnonymousUserConfiguration.class.getName(), "?");
            HashMapDictionary properties = new HashMapDictionary();
            properties.put("companyId", companyId);
            properties.put("userId", anonymousUser.getUserId());
            configuration.update((Dictionary)properties);
            return anonymousUser;
        }
        Configuration configuration = configurationOptional.get();
        Dictionary properties = configuration.getProperties();
        AnonymousUserConfiguration anonymousUserConfiguration = (AnonymousUserConfiguration)ConfigurableUtil.createConfigurable(AnonymousUserConfiguration.class, (Dictionary)properties);
        User anonymousUser = this._userLocalService.fetchUser(anonymousUserConfiguration.userId());
        if (anonymousUser != null) {
            return anonymousUser;
        }
        anonymousUser = this._createAnonymousUser(companyId);
        properties.put("userId", anonymousUser.getUserId());
        configuration.update(properties);
        return anonymousUser;
    }
}

