/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import com.liferay.user.associated.data.web.internal.util.SelectedUserHelper;
import com.liferay.user.associated.data.web.internal.util.UADApplicationSummaryHelper;
import java.util.Collection;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/view_uad_summary"}, service={MVCRenderCommand.class})
public class ViewUADSummaryMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private SelectedUserHelper _selectedUserHelper;
    @Reference
    private UADApplicationSummaryHelper _uadApplicationSummaryHelper;
    @Reference
    private UADRegistry _uadRegistry;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            User selectedUser = this._selectedUserHelper.getSelectedUser((PortletRequest)renderRequest);
            renderRequest.setAttribute("VIEW_UAD_SUMMARY_STEP", (Object)this._determineStep(selectedUser));
        }
        catch (Exception pe) {
            throw new PortletException((Throwable)pe);
        }
        return "/view_uad_summary.jsp";
    }

    private int _determineStep(User selectedUser) throws Exception {
        if (selectedUser.isActive()) {
            return 1;
        }
        int selectedUserPageCount = selectedUser.getPrivateLayoutsPageCount() + selectedUser.getPublicLayoutsPageCount();
        if (selectedUserPageCount > 0) {
            return 2;
        }
        int reviewableUADEntitiesCount = this._uadApplicationSummaryHelper.getReviewableUADEntitiesCount(this._uadRegistry.getUADDisplayStream(), selectedUser.getUserId());
        if (reviewableUADEntitiesCount > 0) {
            return 3;
        }
        Collection<UADAnonymizer> uadAnonymizers = this._uadRegistry.getUADAnonymizers();
        int selectedUserEntityCount = 0;
        for (UADAnonymizer uadAnonymizer : uadAnonymizers) {
            selectedUserEntityCount = (int)((long)selectedUserEntityCount + uadAnonymizer.count(selectedUser.getUserId()));
        }
        if (selectedUserEntityCount > 0) {
            return 4;
        }
        return 5;
    }
}

