/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.configuration;

import com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfiguration;
import java.io.IOException;
import java.util.Optional;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AnonymousUserConfigurationRetriever.class})
public class AnonymousUserConfigurationRetriever {
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public Optional<Configuration> getOptional(long companyId) throws InvalidSyntaxException, IOException {
        String filterString = String.format("(&(service.factoryPid=%s)(companyId=%s))", this._getFactoryPid(), companyId);
        return this._getOptional(filterString);
    }

    public Optional<Configuration> getOptional(long companyId, long userId) throws InvalidSyntaxException, IOException {
        String filterString = String.format("(&(service.factoryPid=%s)(companyId=%s)(userId=%s))", this._getFactoryPid(), String.valueOf(companyId), String.valueOf(userId));
        return this._getOptional(filterString);
    }

    private String _getFactoryPid() {
        return AnonymousUserConfiguration.class.getName();
    }

    private Optional<Configuration> _getOptional(String filterString) throws InvalidSyntaxException, IOException {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (configurations == null) {
            return Optional.empty();
        }
        return Optional.of(configurations[0]);
    }
}

