/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.util;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.user.associated.data.component.UADComponent;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.exporter.UADExporter;
import com.liferay.user.associated.data.web.internal.display.UADApplicationExportDisplay;
import com.liferay.user.associated.data.web.internal.export.background.task.UADExportBackgroundTaskManagerUtil;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UADApplicationExportHelper.class})
public class UADApplicationExportHelper {
    private static final Log _log = LogFactoryUtil.getLog(UADApplicationExportHelper.class);
    @Reference
    private Portal _portal;
    @Reference
    private UADRegistry _uadRegistry;

    public Date getApplicationLastExportDate(String applicationKey, long groupId, long userId) {
        BackgroundTask backgroundTask = UADExportBackgroundTaskManagerUtil.fetchLastBackgroundTask(applicationKey, groupId, userId, 3);
        if (backgroundTask != null) {
            return backgroundTask.getCompletionDate();
        }
        return null;
    }

    public UADApplicationExportDisplay getUADApplicationExportDisplay(String applicationKey, long groupId, long userId) {
        Stream<UADDisplay> uadDisplayStream = this._uadRegistry.getApplicationUADDisplayStream(applicationKey);
        List uadExporters = uadDisplayStream.map(UADComponent::getTypeClass).map(Class::getName).map(key -> this._uadRegistry.getUADExporter((String)key)).collect(Collectors.toList());
        int applicationDataCount = 0;
        for (UADExporter uadExporter : uadExporters) {
            try {
                applicationDataCount += (int)uadExporter.count(userId);
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return new UADApplicationExportDisplay(applicationKey, applicationDataCount, !uadExporters.isEmpty(), this.getApplicationLastExportDate(applicationKey, groupId, userId));
    }

    public List<UADApplicationExportDisplay> getUADApplicationExportDisplays(long groupId, long userId) {
        Set<String> applicationUADDisplayKeySet = this._uadRegistry.getApplicationUADDisplaysKeySet();
        Iterator<String> iterator = applicationUADDisplayKeySet.iterator();
        ArrayList<UADApplicationExportDisplay> uadApplicationExportDisplays = new ArrayList<UADApplicationExportDisplay>();
        while (iterator.hasNext()) {
            String applicationKey = iterator.next();
            uadApplicationExportDisplays.add(this.getUADApplicationExportDisplay(applicationKey, groupId, userId));
        }
        Stream uadApplicationExportDisplayStream = uadApplicationExportDisplays.stream();
        return uadApplicationExportDisplayStream.sorted(Comparator.comparing(UADApplicationExportDisplay::getApplicationKey)).collect(Collectors.toList());
    }
}

