/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.registry;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.component.UADComponent;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.exporter.UADExporter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={UADRegistry.class})
public class UADRegistry {
    private ServiceTrackerMap<String, List<UADDisplay>> _bundleUADDisplayServiceTrackerMap;
    private ServiceTrackerMap<String, List<UADExporter>> _bundleUADExporterServiceTrackerMap;
    private ServiceTrackerMap<String, UADAnonymizer> _uadAnonymizerServiceTrackerMap;
    private ServiceTrackerMap<String, UADDisplay> _uadDisplayServiceTrackerMap;
    private ServiceTrackerMap<String, UADExporter> _uadExporterServiceTrackerMap;

    public List<UADDisplay> getApplicationUADDisplays(String applicationKey) {
        return (List)this._bundleUADDisplayServiceTrackerMap.getService((Object)applicationKey);
    }

    public Set<String> getApplicationUADDisplaysKeySet() {
        return this._bundleUADDisplayServiceTrackerMap.keySet();
    }

    public Stream<UADDisplay> getApplicationUADDisplayStream(String applicationKey) {
        List<UADDisplay> uadDisplayList = this.getApplicationUADDisplays(applicationKey);
        return uadDisplayList.stream();
    }

    public List<UADExporter> getApplicationUADExporters(String applicationKey) {
        return (List)this._bundleUADExporterServiceTrackerMap.getService((Object)applicationKey);
    }

    public Set<String> getApplicationUADExportersKeySet() {
        return this._bundleUADDisplayServiceTrackerMap.keySet();
    }

    public UADAnonymizer getUADAnonymizer(String key) {
        return (UADAnonymizer)this._uadAnonymizerServiceTrackerMap.getService((Object)key);
    }

    public Collection<UADAnonymizer> getUADAnonymizers() {
        return this._uadAnonymizerServiceTrackerMap.values();
    }

    public UADDisplay getUADDisplay(String key) {
        return (UADDisplay)this._uadDisplayServiceTrackerMap.getService((Object)key);
    }

    public Collection<UADDisplay> getUADDisplays() {
        return this._uadDisplayServiceTrackerMap.values();
    }

    public Stream<UADDisplay> getUADDisplayStream() {
        return this.getUADDisplays().stream();
    }

    public UADExporter getUADExporter(String key) {
        return (UADExporter)this._uadExporterServiceTrackerMap.getService((Object)key);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleUADDisplayServiceTrackerMap = this.getMultiValueServiceTrackerMap(bundleContext, UADDisplay.class);
        this._bundleUADExporterServiceTrackerMap = this.getMultiValueServiceTrackerMap(bundleContext, UADExporter.class);
        this._uadAnonymizerServiceTrackerMap = this.getSingleValueServiceTrackerMap(bundleContext, UADAnonymizer.class);
        this._uadDisplayServiceTrackerMap = this.getSingleValueServiceTrackerMap(bundleContext, UADDisplay.class);
        this._uadExporterServiceTrackerMap = this.getSingleValueServiceTrackerMap(bundleContext, UADExporter.class);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleUADDisplayServiceTrackerMap.close();
        this._bundleUADExporterServiceTrackerMap.close();
        this._uadAnonymizerServiceTrackerMap.close();
        this._uadDisplayServiceTrackerMap.close();
        this._uadExporterServiceTrackerMap.close();
    }

    protected <T extends UADComponent> ServiceTrackerMap<String, List<T>> getMultiValueServiceTrackerMap(BundleContext bundleContext, Class<T> clazz) {
        return ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, clazz, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (uadDisplay, emitter) -> {
            Bundle bundle = FrameworkUtil.getBundle(uadDisplay.getClass());
            emitter.emit((Object)bundle.getSymbolicName());
        }));
    }

    protected <T extends UADComponent> ServiceTrackerMap<String, T> getSingleValueServiceTrackerMap(BundleContext bundleContext, Class<T> clazz) {
        return ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, clazz, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (uadComponent, emitter) -> {
            Class uadClass = uadComponent.getTypeClass();
            emitter.emit((Object)uadClass.getName());
        }));
    }
}

