/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.portlet.action;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.web.internal.display.UADEntity;
import com.liferay.user.associated.data.web.internal.display.ViewUADEntitiesDisplay;
import com.liferay.user.associated.data.web.internal.registry.UADRegistry;
import com.liferay.user.associated.data.web.internal.util.SafeDisplayValueUtil;
import com.liferay.user.associated.data.web.internal.util.SelectedUserHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_user_associated_data_web_portlet_UserAssociatedData", "mvc.command.name=/view_uad_entities"}, service={MVCRenderCommand.class})
public class ViewUADEntitiesMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private Portal _portal;
    @Reference
    private SelectedUserHelper _selectedUserHelper;
    @Reference
    private UADRegistry _uadRegistry;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            User selectedUser = this._selectedUserHelper.getSelectedUser((PortletRequest)renderRequest);
            String applicationKey = ParamUtil.getString((PortletRequest)renderRequest, (String)"applicationKey");
            String uadRegistryKey = ParamUtil.getString((PortletRequest)renderRequest, (String)"uadRegistryKey");
            ViewUADEntitiesDisplay viewUADEntitiesDisplay = new ViewUADEntitiesDisplay();
            viewUADEntitiesDisplay.setApplicationKey(applicationKey);
            LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)renderResponse);
            PortletURL currentURL = PortletURLUtil.getCurrent((PortletRequest)renderRequest, (MimeResponse)renderResponse);
            viewUADEntitiesDisplay.setNavigationItems(this._getNavigationItems(applicationKey, uadRegistryKey, currentURL, liferayPortletResponse));
            UADDisplay uadDisplay = this._uadRegistry.getUADDisplay(uadRegistryKey);
            viewUADEntitiesDisplay.setSearchContainer(this._getSearchContainer(renderRequest, currentURL, uadDisplay, selectedUser.getUserId(), liferayPortletResponse));
            viewUADEntitiesDisplay.setTypeName(uadDisplay.getTypeName(LocaleThreadLocal.getThemeDisplayLocale()));
            viewUADEntitiesDisplay.setUADRegistryKey(uadRegistryKey);
            renderRequest.setAttribute("INFO_PANEL_UAD_DISPLAY", (Object)uadDisplay);
            renderRequest.setAttribute("VIEW_UAD_ENTITIES_DISPLAY", (Object)viewUADEntitiesDisplay);
        }
        catch (Exception pe) {
            throw new PortletException((Throwable)pe);
        }
        return "/view_uad_entities.jsp";
    }

    private <T> UADEntity<T> _constructUADEntity(T entity, UADDisplay<T> uadDisplay, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        UADEntity<T> uadEntity = new UADEntity<T>(entity, uadDisplay.getPrimaryKey(entity), uadDisplay.getEditURL(entity, liferayPortletRequest, liferayPortletResponse));
        Map columnFieldValues = uadDisplay.getFieldValues(entity, uadDisplay.getColumnFieldNames());
        for (String columnFieldName : uadDisplay.getColumnFieldNames()) {
            uadEntity.addColumnEntry(columnFieldName, SafeDisplayValueUtil.get(columnFieldValues.get(columnFieldName)));
        }
        return uadEntity;
    }

    private List<NavigationItem> _getNavigationItems(String applicationKey, String uadRegistryKey, PortletURL currentURL, LiferayPortletResponse liferayPortletResponse) throws PortletException {
        NavigationItemList navigationItemList = new NavigationItemList();
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        PortletURL tabPortletURL = PortletURLUtil.clone((PortletURL)currentURL, (LiferayPortletResponse)liferayPortletResponse);
        List<UADDisplay> applicationUADDisplays = this._uadRegistry.getApplicationUADDisplays(applicationKey);
        applicationUADDisplays.forEach(uadDisplay -> navigationItemList.add(navigationItem -> {
            Class uadClass = uadDisplay.getTypeClass();
            navigationItem.setActive(uadRegistryKey.equals(uadClass.getName()));
            navigationItem.setHref(tabPortletURL, new Object[]{"uadRegistryKey", uadClass.getName()});
            navigationItem.setLabel(uadDisplay.getTypeName(locale));
        }));
        return navigationItemList;
    }

    private SearchContainer<UADEntity> _getSearchContainer(RenderRequest renderRequest, PortletURL currentURL, UADDisplay uadDisplay, long selectedUserId, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletRequest liferayPortletRequest = this._portal.getLiferayPortletRequest((PortletRequest)renderRequest);
        SearchContainer searchContainer = new SearchContainer((PortletRequest)renderRequest, currentURL, null, null);
        searchContainer.setEmptyResultsMessage("no-entities-remain-of-this-type");
        searchContainer.setId("UADEntities");
        List entities = uadDisplay.getRange(selectedUserId, searchContainer.getStart(), searchContainer.getEnd());
        ArrayList uadEntities = new ArrayList();
        for (Object entity : entities) {
            uadEntities.add(this._constructUADEntity(entity, uadDisplay, liferayPortletRequest, liferayPortletResponse));
        }
        searchContainer.setResults(uadEntities);
        EmptyOnClickRowChecker rowChecker = new EmptyOnClickRowChecker((PortletResponse)liferayPortletResponse);
        Class uadClass = uadDisplay.getTypeClass();
        rowChecker.setRememberCheckBoxStateURLRegex("uadRegistryKey=" + uadClass.getName());
        searchContainer.setRowChecker((RowChecker)rowChecker);
        searchContainer.setTotal((int)uadDisplay.count(selectedUserId));
        return searchContainer;
    }
}

