/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.display.context;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.user.associated.data.web.internal.export.background.task.UADExportBackgroundTaskManagerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class UADExportProcessDisplayContext {
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private SearchContainer _searchContainer;

    public UADExportProcessDisplayContext(HttpServletRequest request, RenderResponse renderResponse) {
        this._request = request;
        this._renderResponse = renderResponse;
    }

    public int getBackgroundTaskStatus(String status) {
        if (status.equals("failed")) {
            return 2;
        }
        if (status.equals("in-progress")) {
            return 1;
        }
        if (status.equals("successful")) {
            return 3;
        }
        return 0;
    }

    public Comparator<BackgroundTask> getComparator(String orderByCol, String orderByType) {
        Comparator comparator = Comparator.comparing(BackgroundTask::getCreateDate);
        if (orderByCol.equals("name")) {
            comparator = (backgroundTask1, backgroundTask2) -> {
                Map taskContextMap1 = backgroundTask1.getTaskContextMap();
                Map taskContextMap2 = backgroundTask2.getTaskContextMap();
                String applicationKey1 = (String)taskContextMap1.get("applicationKey");
                String applicationKey2 = (String)taskContextMap2.get("applicationKey");
                return applicationKey1.compareTo(applicationKey2);
            };
        }
        if (orderByType.equals("desc")) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
        return this._navigation;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"create-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"desc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() throws PortalException {
        PortletRequest portletRequest = (PortletRequest)this._request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this._request.getAttribute("javax.portlet.response");
        PortletURL portletURL = PortletURLUtil.getCurrent((LiferayPortletRequest)PortalUtil.getLiferayPortletRequest((PortletRequest)portletRequest), (LiferayPortletResponse)PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse));
        portletURL.setParameter("mvcRenderCommandName", "/view_uad_export_processes");
        User selectedUser = PortalUtil.getSelectedUser((HttpServletRequest)this._request);
        portletURL.setParameter("p_u_i_d", String.valueOf(selectedUser.getUserId()));
        portletURL.setParameter("navigation", this.getNavigation());
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL;
    }

    public SearchContainer getSearchContainer() throws PortalException {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        PortletRequest portletRequest = (PortletRequest)this._request.getAttribute("javax.portlet.request");
        SearchContainer searchContainer = new SearchContainer(portletRequest, this.getPortletURL(), null, "no-personal-data-export-processes-were-found");
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByType(this.getOrderByType());
        String navigation = this.getNavigation();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User selectedUser = PortalUtil.getSelectedUser((HttpServletRequest)this._request);
        List<Object> results = null;
        if (navigation.equals("failed") || navigation.equals("in-progress") || navigation.equals("successful")) {
            int status = this.getBackgroundTaskStatus(navigation);
            searchContainer.setTotal(UADExportBackgroundTaskManagerUtil.getBackgroundTasksCount(themeDisplay.getScopeGroupId(), selectedUser.getUserId(), status));
            results = UADExportBackgroundTaskManagerUtil.getBackgroundTasks(themeDisplay.getScopeGroupId(), selectedUser.getUserId(), status);
        } else {
            searchContainer.setTotal(UADExportBackgroundTaskManagerUtil.getBackgroundTasksCount(themeDisplay.getScopeGroupId(), selectedUser.getUserId()));
            results = UADExportBackgroundTaskManagerUtil.getBackgroundTasks(themeDisplay.getScopeGroupId(), selectedUser.getUserId());
        }
        Stream backgroundTaskStream = results.stream();
        results = backgroundTaskStream.sorted(this.getComparator(searchContainer.getOrderByCol(), searchContainer.getOrderByType())).skip(searchContainer.getStart()).limit(searchContainer.getDelta()).collect(Collectors.toList());
        searchContainer.setResults(results);
        this._searchContainer = searchContainer;
        return this._searchContainer;
    }
}

