/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.web.internal.configuration;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.web.internal.configuration.AnonymousUserConfigurationRetriever;
import java.io.IOException;
import java.util.Optional;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    private AnonymousUserConfigurationRetriever _anonymousUserConfigurationRetriever;

    public void onAfterRemove(User user) throws ModelListenerException {
        try {
            this._deleteAnonymousUserConfiguration(user.getCompanyId(), user.getUserId());
        }
        catch (IOException | InvalidSyntaxException e) {
            throw new ModelListenerException(e);
        }
    }

    private void _deleteAnonymousUserConfiguration(long companyId, long userId) throws InvalidSyntaxException, IOException {
        Optional<Configuration> configurationOptional = this._anonymousUserConfigurationRetriever.getOptional(companyId, userId);
        if (!configurationOptional.isPresent()) {
            return;
        }
        Configuration configuration = configurationOptional.get();
        configuration.delete();
    }
}

