/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.exception.DLStorageQuotaExceededException;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.upload.UploadResponseHandler;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, property={"upload.response.handler=multiple"}, service={UploadResponseHandler.class})
public class MultipleUploadResponseHandler
implements UploadResponseHandler {
    private volatile DLConfiguration _dlConfiguration;
    @Reference
    private Language _language;

    public JSONObject onFailure(PortletRequest portletRequest, PortalException portalException) throws PortalException {
        String message = "";
        int status = 0;
        if (portalException instanceof AntivirusScannerException || portalException instanceof DLStorageQuotaExceededException || portalException instanceof DuplicateFileEntryException || portalException instanceof FileExtensionException || portalException instanceof FileNameException || portalException instanceof FileSizeException || portalException instanceof UploadRequestSizeException) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (portalException instanceof AntivirusScannerException) {
                AntivirusScannerException antivirusScannerException = (AntivirusScannerException)portalException;
                message = themeDisplay.translate(antivirusScannerException.getMessageKey());
                status = 494;
            }
            if (portalException instanceof DLStorageQuotaExceededException) {
                message = themeDisplay.translate("you-have-exceeded-the-x-storage-quota-for-this-instance", new Object[]{this._language.formatStorageSize((double)PropsValues.DATA_LIMIT_DL_STORAGE_MAX_SIZE, themeDisplay.getLocale())});
                status = 493;
            } else if (portalException instanceof DuplicateFileEntryException) {
                message = themeDisplay.translate("please-enter-a-unique-document-name");
                status = 490;
            } else if (portalException instanceof FileExtensionException) {
                message = themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{this._getAllowedFileExtensions()});
                status = 491;
            } else if (portalException instanceof FileNameException) {
                message = themeDisplay.translate("please-enter-a-file-with-a-valid-file-name");
                status = 492;
            } else if (portalException instanceof FileSizeException) {
                FileSizeException fileSizeException = (FileSizeException)portalException;
                message = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{this._language.formatStorageSize((double)fileSizeException.getMaxSize(), themeDisplay.getLocale())});
                status = 493;
            } else if (portalException instanceof UploadRequestSizeException) {
                status = 495;
            }
        }
        return JSONUtil.put((String)"message", (Object)message).put("status", status);
    }

    public JSONObject onSuccess(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) throws PortalException {
        return JSONUtil.put((String)"groupId", (Object)fileEntry.getGroupId()).put("name", fileEntry.getTitle()).put("title", uploadPortletRequest.getFileName("file")).put("uuid", fileEntry.getUuid());
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private String _getAllowedFileExtensions() {
        Object[] allowedFileExtensions = this._dlConfiguration.fileExtensions();
        return StringUtil.merge((Object[])allowedFileExtensions, (String)", ");
    }
}

