/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.upload.AttachmentContentUpdater;
import com.liferay.upload.AttachmentElementHandler;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={AttachmentContentUpdater.class})
public class DefaultAttachmentContentUpdater
implements AttachmentContentUpdater {
    private ServiceTrackerList<AttachmentElementHandler> _serviceTrackerList;

    public String updateContent(String content, String contentType, UnsafeFunction<FileEntry, FileEntry, PortalException> saveTempFileUnsafeFunction) throws PortalException {
        if (!"text/html".equals(contentType)) {
            throw new IllegalArgumentException("Unsupported content type: " + contentType);
        }
        for (AttachmentElementHandler attachmentElementHandler : this._serviceTrackerList) {
            content = attachmentElementHandler.replaceAttachmentElements(content, saveTempFileUnsafeFunction);
        }
        return content;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, AttachmentElementHandler.class);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }
}

