/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.upload.AttachmentElementHandler;
import com.liferay.upload.AttachmentElementReplacer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"format=html", "html.tag.name=img"}, service={AttachmentElementHandler.class})
public class HTMLImageAttachmentElementHandler
implements AttachmentElementHandler {
    private static final String _ATTRIBUTE_LIST_REGEXP = "(?:\\s*?\\w+\\s*?=\\s*?\"[^\"]*\")*?\\s*?";
    private static final Pattern _tempAttachmentPattern = Pattern.compile(StringBundler.concat((String[])new String[]{"<\\s*?img", "(?:\\s*?\\w+\\s*?=\\s*?\"[^\"]*\")*?\\s*?", "data-image-id", "\\s*?=\\s*?\"", "([^\"]*)\"", "(?:\\s*?\\w+\\s*?=\\s*?\"[^\"]*\")*?\\s*?", "/>"}));
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(format=html)(html.tag.name=img))")
    private volatile AttachmentElementReplacer _attachmentElementReplacer;

    public String replaceAttachmentElements(String content, UnsafeFunction<FileEntry, FileEntry, PortalException> saveTempFileUnsafeFunction) throws PortalException {
        StringBuffer sb = new StringBuffer(content.length());
        HashMap<String, FileEntry> fileEntries = new HashMap<String, FileEntry>();
        Matcher matcher = _tempAttachmentPattern.matcher(content);
        while (matcher.find()) {
            String fileName = matcher.group(0);
            FileEntry fileEntry = (FileEntry)fileEntries.get(fileName);
            if (fileEntry == null) {
                fileEntry = (FileEntry)saveTempFileUnsafeFunction.apply((Object)this._getFileEntry(matcher));
                fileEntries.put(fileName, fileEntry);
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this._attachmentElementReplacer.replace(fileName, fileEntry)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private FileEntry _getFileEntry(Matcher matcher) throws PortalException {
        long fileEntryId = GetterUtil.getLong((String)matcher.group(1));
        return PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
    }
}

