/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.upload.UploadResponseHandler;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, property={"upload.response.handler.system.default=true"}, service={UploadResponseHandler.class})
public class DefaultUploadResponseHandler
implements UploadResponseHandler {
    private volatile DLConfiguration _dlConfiguration;

    public JSONObject onFailure(PortletRequest portletRequest, PortalException pe) throws PortalException {
        JSONObject jsonObject = JSONUtil.put((String)"success", (Object)Boolean.FALSE);
        if (pe instanceof AntivirusScannerException || pe instanceof FileExtensionException || pe instanceof FileNameException || pe instanceof FileSizeException || pe instanceof UploadRequestSizeException) {
            String errorMessage = "";
            int errorType = 0;
            if (pe instanceof AntivirusScannerException) {
                errorType = 494;
                AntivirusScannerException ase = (AntivirusScannerException)pe;
                ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                errorMessage = themeDisplay.translate(ase.getMessageKey());
            } else if (pe instanceof FileExtensionException) {
                errorType = 491;
                errorMessage = this._getAllowedFileExtensions();
            } else if (pe instanceof FileNameException) {
                errorType = 492;
            } else if (pe instanceof FileSizeException) {
                errorType = 493;
            } else if (pe instanceof UploadRequestSizeException) {
                errorType = 495;
            }
            JSONObject errorJSONObject = JSONUtil.put((String)"errorType", (Object)errorType).put("message", errorMessage);
            jsonObject.put("error", errorJSONObject);
        }
        return jsonObject;
    }

    public JSONObject onSuccess(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) throws PortalException {
        JSONObject imageJSONObject = JSONUtil.put((String)"attributeDataImageId", (Object)"data-image-id").put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("mimeType", fileEntry.getMimeType());
        String randomId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"randomId");
        imageJSONObject.put("randomId", randomId).put("title", fileEntry.getTitle()).put("type", "document");
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String url = PortletFileRepositoryUtil.getPortletFileEntryURL((ThemeDisplay)themeDisplay, (FileEntry)fileEntry, (String)"");
        imageJSONObject.put("url", url).put("uuid", fileEntry.getUuid());
        return JSONUtil.put((String)"file", (Object)imageJSONObject).put("success", (Object)Boolean.TRUE);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private String _getAllowedFileExtensions() {
        String allowedFileExtensionsString = "";
        Object[] allowedFileExtensions = this._dlConfiguration.fileExtensions();
        allowedFileExtensionsString = StringUtil.merge((Object[])allowedFileExtensions, (String)", ");
        return allowedFileExtensionsString;
    }
}

