/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.upload.UploadResponseHandler;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, property={"upload.response.handler.system.default=true"}, service={UploadResponseHandler.class})
public class DefaultUploadResponseHandler
implements UploadResponseHandler {
    private volatile DLConfiguration _dlConfiguration;

    public JSONObject onFailure(PortletRequest portletRequest, PortalException portalException) throws PortalException {
        JSONObject jsonObject = JSONUtil.put((String)"success", (Object)Boolean.FALSE);
        if (portalException instanceof AntivirusScannerException || portalException instanceof FileExtensionException || portalException instanceof FileNameException || portalException instanceof FileSizeException || portalException instanceof UploadRequestSizeException) {
            String errorMessage = "";
            int errorType = 0;
            if (portalException instanceof AntivirusScannerException) {
                errorType = 494;
                AntivirusScannerException antivirusScannerException = (AntivirusScannerException)portalException;
                ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                errorMessage = themeDisplay.translate(antivirusScannerException.getMessageKey());
            } else if (portalException instanceof FileExtensionException) {
                errorType = 491;
                errorMessage = this._getAllowedFileExtensions();
            } else if (portalException instanceof FileNameException) {
                errorType = 492;
            } else if (portalException instanceof FileSizeException) {
                errorType = 493;
            } else if (portalException instanceof UploadRequestSizeException) {
                errorType = 495;
            }
            jsonObject.put("error", JSONUtil.put((String)"errorType", (Object)errorType).put("message", errorMessage));
        }
        return jsonObject;
    }

    public JSONObject onSuccess(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) throws PortalException {
        JSONObject imageJSONObject = JSONUtil.put((String)"attributeDataImageId", (Object)"data-image-id").put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("mimeType", fileEntry.getMimeType());
        String randomId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"randomId");
        imageJSONObject.put("randomId", randomId).put("title", fileEntry.getTitle()).put("type", "document");
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String url = PortletFileRepositoryUtil.getPortletFileEntryURL((ThemeDisplay)themeDisplay, (FileEntry)fileEntry, (String)"");
        imageJSONObject.put("url", url).put("uuid", fileEntry.getUuid());
        return JSONUtil.put((String)"file", (Object)imageJSONObject).put("success", (Object)Boolean.TRUE);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private String _getAllowedFileExtensions() {
        Object[] allowedFileExtensions = this._dlConfiguration.fileExtensions();
        return StringUtil.merge((Object[])allowedFileExtensions, (String)", ");
    }
}

