/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.upload.UniqueFileNameProvider;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;

@Component
public class DefaultUniqueFileNameProvider
implements UniqueFileNameProvider {
    private static final int _UNIQUE_FILE_NAME_TRIES = 50;
    private static final Pattern _pattern = Pattern.compile("(?<name>.+) \\(\\d+\\)(\\.(?<extension>[^.]+))?");

    public String provide(String fileName, Predicate<String> predicate) throws PortalException {
        String uniqueFileName = fileName = this._removeParentheticalSuffix(fileName);
        int tries = 0;
        while (predicate.test(uniqueFileName)) {
            if (tries >= 50) {
                throw new PortalException("Unable to get a unique file name for " + fileName);
            }
            uniqueFileName = FileUtil.appendParentheticalSuffix((String)fileName, (String)String.valueOf(++tries));
        }
        return uniqueFileName;
    }

    private String _removeParentheticalSuffix(String fileName) {
        Matcher matcher = _pattern.matcher(fileName);
        if (matcher.matches()) {
            String name = matcher.group("name");
            String extension = matcher.group("extension");
            fileName = name;
            if (extension != null) {
                fileName = fileName + "." + extension;
            }
        }
        return fileName;
    }
}

