/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.web.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.TrashHelper;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={TrashUtil.class})
public class TrashUtil {
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;

    public void addBaseModelBreadcrumbEntries(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, String className, long classPK, PortletURL containerModelURL) throws PortalException, PortletException {
        this.addBreadcrumbEntries(request, liferayPortletResponse, className, classPK, "classPK", containerModelURL, true);
    }

    public void addContainerModelBreadcrumbEntries(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, String className, long classPK, PortletURL containerModelURL) throws PortalException, PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        String rootContainerModelTitle = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)trashHandler.getRootContainerModelName());
        if (classPK == 0L) {
            this._portal.addPortletBreadcrumbEntry(request, rootContainerModelTitle, null);
            return;
        }
        containerModelURL.setParameter("containerModelId", "0");
        this._portal.addPortletBreadcrumbEntry(request, rootContainerModelTitle, containerModelURL.toString());
        this.addBreadcrumbEntries(request, liferayPortletResponse, className, classPK, "containerModelId", containerModelURL, false);
    }

    protected void addBreadcrumbEntries(HttpServletRequest request, LiferayPortletResponse liferayPortletResponse, String className, long classPK, String paramName, PortletURL containerModelURL, boolean checkInTrashContainers) throws PortalException, PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)containerModelURL, (LiferayPortletResponse)liferayPortletResponse);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        List containerModels = trashHandler.getParentContainerModels(classPK);
        Collections.reverse(containerModels);
        for (ContainerModel containerModel : containerModels) {
            TrashHandler containerModelTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)containerModel.getModelClassName());
            if (checkInTrashContainers && !containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) continue;
            portletURL.setParameter(paramName, String.valueOf(containerModel.getContainerModelId()));
            String name = containerModel.getContainerModelName();
            if (containerModelTrashHandler.isInTrash(containerModel.getContainerModelId())) {
                name = this._trashHelper.getOriginalTitle(name);
            }
            this._portal.addPortletBreadcrumbEntry(request, name, portletURL.toString());
        }
        TrashRenderer trashRenderer = trashHandler.getTrashRenderer(classPK);
        this._portal.addPortletBreadcrumbEntry(request, trashRenderer.getTitle(themeDisplay.getLocale()), null);
    }
}

