/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.web.internal.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.util.comparator.EntryCreateDateComparator;
import com.liferay.trash.util.comparator.EntryTypeComparator;
import com.liferay.trash.util.comparator.EntryUserNameComparator;
import com.liferay.trash.web.internal.search.EntryDisplayTerms;
import com.liferay.trash.web.internal.search.EntrySearchTerms;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class EntrySearch
extends SearchContainer<TrashEntry> {
    public static final String EMPTY_RESULTS_MESSAGE = "the-recycle-bin-is-empty";
    public static List<String> headerNames = new ArrayList<String>();
    public static Map<String, String> orderableHeaders = new HashMap<String, String>();
    private static final Log _log;

    public EntrySearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new EntryDisplayTerms(portletRequest), (DisplayTerms)new EntrySearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue(portletId, "entries-order-by-col", orderByCol);
                preferences.setValue(portletId, "entries-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "entries-order-by-col", "removed-date");
                orderByType = preferences.getValue(portletId, "entries-order-by-type", "asc");
            }
            OrderByComparator<TrashEntry> orderByComparator = this._getEntryOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to initialize entry search", (Throwable)e);
        }
    }

    private OrderByComparator<TrashEntry> _getEntryOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        EntryUserNameComparator orderByComparator = null;
        if (orderByCol.equals("removed-by")) {
            orderByComparator = new EntryUserNameComparator(orderByAsc);
        } else if (orderByCol.equals("removed-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("type")) {
            orderByComparator = new EntryTypeComparator(orderByAsc);
        }
        return orderByComparator;
    }

    static {
        headerNames.add("name");
        headerNames.add("type");
        headerNames.add("removed-date");
        headerNames.add("removed-by");
        orderableHeaders.put("name", "name");
        orderableHeaders.put("removed-by", "removed-by");
        orderableHeaders.put("removed-date", "removed-date");
        orderableHeaders.put("type", "type");
        _log = LogFactoryUtil.getLog(EntrySearch.class);
    }
}

