/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.web.internal.portlet;

import com.liferay.petra.model.adapter.util.ModelAdapterUtil;
import com.liferay.portal.kernel.exception.TrashPermissionException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashEntryService;
import com.liferay.trash.web.internal.util.TrashUndoUtil;
import com.liferay.trash.web.internal.util.TrashUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-trash", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.icon=/icons/trash.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Trash", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_trash_web_portlet_TrashPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class, TrashPortlet.class})
public class TrashPortlet
extends MVCPortlet {
    @Reference
    private Portal _portal;
    private TrashEntryLocalService _trashEntryLocalService;
    private TrashEntryService _trashEntryService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashUtil _trashUtil;

    public void changeDisplayStyle(ActionRequest actionRequest, ActionResponse actionResponse) {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)actionRequest);
        portalPreferences.setValue("com_liferay_trash_web_portlet_TrashPortlet", "display-style", displayStyle);
    }

    public void deleteEntries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        if (trashEntryId > 0L) {
            this._trashEntryService.deleteEntry(trashEntryId);
            return;
        }
        long[] deleteEntryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        if (deleteEntryIds.length > 0) {
            for (long deleteEntryId : deleteEntryIds) {
                this._trashEntryService.deleteEntry(deleteEntryId);
            }
            return;
        }
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        if (Validator.isNotNull((String)className) && classPK > 0L) {
            this._trashEntryService.deleteEntry(className, classPK);
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    public void emptyTrash(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
        this._trashEntryService.deleteEntries(groupId);
    }

    public void moveEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long containerModelId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"containerModelId");
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)className, (PortletRequest)actionRequest);
        this._trashEntryService.moveEntry(className, classPK, containerModelId, serviceContext);
        TrashUndoUtil.addRestoreData(actionRequest, className, classPK);
        this.sendRedirect(actionRequest, actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("TRASH_HELPER", (Object)this._trashHelper);
        renderRequest.setAttribute("TRASH_UTIL", (Object)this._trashUtil);
        super.render(renderRequest, renderResponse);
    }

    public void restoreEntries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.checkEntry(actionRequest, actionResponse);
        ArrayList<ObjectValuePair<String, Long>> entries = new ArrayList<ObjectValuePair<String, Long>>();
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        if (trashEntryId > 0L) {
            TrashEntry entry = this._trashEntryService.restoreEntry(trashEntryId);
            entries.add(new ObjectValuePair((Object)entry.getClassName(), (Object)entry.getClassPK()));
        } else {
            long[] restoreEntryIds;
            for (long restoreEntryId : restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
                TrashEntry entry = this._trashEntryService.restoreEntry(restoreEntryId);
                entries.add((ObjectValuePair<String, Long>)new ObjectValuePair((Object)entry.getClassName(), (Object)entry.getClassPK()));
            }
        }
        TrashUndoUtil.addRestoreData(actionRequest, entries);
        this.sendRedirect(actionRequest, actionResponse);
    }

    public void restoreEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("rename")) {
            this.checkEntry(actionRequest, actionResponse);
            this.restoreRename(actionRequest, actionResponse);
        } else if (cmd.equals("override")) {
            this.restoreOverride(actionRequest, actionResponse);
        }
    }

    public void restoreOverride(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        long duplicateEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"duplicateEntryId");
        TrashEntry entry = this._trashEntryService.restoreEntry(trashEntryId, duplicateEntryId, null);
        TrashUndoUtil.addRestoreData(actionRequest, entry.getClassName(), entry.getClassPK());
        this.sendRedirect(actionRequest, actionResponse);
    }

    public void restoreRename(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        String newName = ParamUtil.getString((PortletRequest)actionRequest, (String)"newName");
        if (Validator.isNull((String)newName)) {
            String oldName = ParamUtil.getString((PortletRequest)actionRequest, (String)"oldName");
            newName = this._trashHelper.getNewName(themeDisplay, null, 0L, oldName);
        }
        TrashEntry entry = this._trashEntryService.restoreEntry(trashEntryId, 0L, newName);
        TrashUndoUtil.addRestoreData(actionRequest, entry.getClassName(), entry.getClassPK());
        this.sendRedirect(actionRequest, actionResponse);
    }

    protected void checkEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        String newName = ParamUtil.getString((PortletRequest)actionRequest, (String)"newName");
        TrashEntry entry = this._trashEntryLocalService.fetchTrashEntry(trashEntryId);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
        try {
            trashHandler.checkRestorableEntry((com.liferay.trash.kernel.model.TrashEntry)ModelAdapterUtil.adapt(com.liferay.trash.kernel.model.TrashEntry.class, (Object)entry), -1L, newName);
        }
        catch (com.liferay.trash.kernel.exception.RestoreEntryException ree) {
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
            PortletURL renderURL = liferayPortletResponse.createRenderURL();
            renderURL.setParameter("mvcPath", "/restore_entry.jsp");
            renderURL.setParameter("redirect", redirect);
            renderURL.setParameter("trashEntryId", String.valueOf(ree.getTrashEntryId()));
            renderURL.setParameter("duplicateEntryId", String.valueOf(ree.getDuplicateEntryId()));
            renderURL.setParameter("oldName", ree.getOldName());
            renderURL.setParameter("overridable", String.valueOf(ree.isOverridable()));
            actionRequest.setAttribute("REDIRECT", (Object)renderURL.toString());
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            this.sendRedirect(actionRequest, actionResponse);
            throw new RestoreEntryException(ree.getType(), ree.getCause());
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof RestoreEntryException || cause instanceof com.liferay.trash.kernel.exception.RestoreEntryException || cause instanceof TrashPermissionException;
    }

    @Reference(unbind="-")
    protected void setTrashEntryLocalService(TrashEntryLocalService trashEntryLocalService) {
        this._trashEntryLocalService = trashEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }
}

