/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashEntryList;
import com.liferay.trash.service.TrashEntryLocalServiceUtil;
import com.liferay.trash.service.TrashEntryServiceUtil;
import com.liferay.trash.util.comparator.EntryCreateDateComparator;
import com.liferay.trash.web.internal.search.EntrySearch;
import com.liferay.trash.web.internal.search.EntrySearchTerms;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class TrashDisplayContext {
    private boolean _approximate;
    private String _containerModelRedirectURL;
    private String _displayStyle;
    private EntrySearch _entrySearch;
    private String _keywords;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private final HttpServletRequest _request;
    private TrashEntry _trashEntry;
    private TrashHandler _trashHandler;
    private TrashRenderer _trashRenderer;

    public TrashDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSelectedEntries");
                    dropdownItem.setIcon("trash");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClassName() {
        TrashEntry trashEntry = this.getTrashEntry();
        if (trashEntry != null) {
            return trashEntry.getClassName();
        }
        String className = "";
        long classNameId = this.getClassNameId();
        if (classNameId > 0L) {
            className = PortalUtil.getClassName((long)this.getClassNameId());
        }
        return className;
    }

    public long getClassNameId() {
        TrashEntry trashEntry = this.getTrashEntry();
        if (trashEntry != null) {
            return trashEntry.getClassNameId();
        }
        return ParamUtil.getLong((HttpServletRequest)this._request, (String)"classNameId");
    }

    public long getClassPK() {
        TrashEntry trashEntry = this.getTrashEntry();
        if (trashEntry != null) {
            return trashEntry.getClassPK();
        }
        return ParamUtil.getLong((HttpServletRequest)this._request, (String)"classPK");
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getContainerModelRedirectURL() {
        if (Validator.isNotNull((String)this._containerModelRedirectURL)) {
            return this._containerModelRedirectURL;
        }
        String redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        if (Validator.isNull((String)redirect)) {
            PortletURL redirectURL = this._liferayPortletResponse.createRenderURL();
            redirectURL.setParameter("mvcPath", "/view_content.jsp");
            long trashEntryId = this.getTrashEntryId();
            long classNameId = this.getClassNameId();
            long classPK = this.getClassPK();
            if (trashEntryId > 0L) {
                redirectURL.setParameter("trashEntryId", String.valueOf(trashEntryId));
            } else if (classNameId > 0L && classPK > 0L) {
                redirectURL.setParameter("classNameId", String.valueOf(classNameId));
                redirectURL.setParameter("classPK", String.valueOf(classPK));
            }
            redirect = redirectURL.toString();
        }
        this._containerModelRedirectURL = redirect;
        return redirect;
    }

    public String getContentClearResultsURL() {
        PortletURL clearResultsURL = this.getContentPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public List<DropdownItem> getContentFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(TrashDisplayContext.this._getContentFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"filter-by-navigation"));
                });
            }
        };
    }

    public PortletURL getContentPortletURL() {
        String keywords;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        String displayStyle = this.getDisplayStyle();
        if (Validator.isNotNull((String)displayStyle)) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        return portletURL;
    }

    public String getContentSearchActionURL() {
        PortletURL searchActionURL = this.getContentPortletURL();
        return searchActionURL.toString();
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = portalPreferences.getValue("com_liferay_trash_web_portlet_TrashPortlet", "display-style", "list");
        return this._displayStyle;
    }

    public EntrySearch getEntrySearch() throws PortalException {
        if (this._entrySearch != null) {
            return this._entrySearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        EntrySearch entrySearch = new EntrySearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
        entrySearch.setOrderByCol(this.getOrderByCol());
        boolean orderByAsc = false;
        if (Objects.equals(this.getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        entrySearch.setOrderByComparator((OrderByComparator)new EntryCreateDateComparator(orderByAsc));
        entrySearch.setOrderByType(this.getOrderByType());
        EmptyOnClickRowChecker emptyOnClickRowChecker = new EmptyOnClickRowChecker((PortletResponse)this._liferayPortletResponse);
        emptyOnClickRowChecker.setRememberCheckBoxStateURLRegex("^(?!.*" + this._liferayPortletResponse.getNamespace() + "redirect).*^(?!.*/entry/)");
        entrySearch.setRowChecker((RowChecker)emptyOnClickRowChecker);
        EntrySearchTerms searchTerms = (EntrySearchTerms)entrySearch.getSearchTerms();
        List trashEntries = null;
        if (Validator.isNotNull((String)searchTerms.getKeywords())) {
            Sort sort = SortFactoryUtil.getSort(TrashEntry.class, (String)entrySearch.getOrderByCol(), (String)entrySearch.getOrderByType());
            BaseModelSearchResult baseModelSearchResult = TrashEntryLocalServiceUtil.searchTrashEntries((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)searchTerms.getKeywords(), (int)entrySearch.getStart(), (int)entrySearch.getEnd(), (Sort)sort);
            entrySearch.setTotal(baseModelSearchResult.getLength());
            trashEntries = baseModelSearchResult.getBaseModels();
        } else {
            TrashEntryList trashEntryList = null;
            trashEntryList = Objects.equals(this.getNavigation(), "all") ? TrashEntryServiceUtil.getEntries((long)themeDisplay.getScopeGroupId(), (int)entrySearch.getStart(), (int)entrySearch.getEnd(), (OrderByComparator)entrySearch.getOrderByComparator()) : TrashEntryServiceUtil.getEntries((long)themeDisplay.getScopeGroupId(), (String)this.getNavigation(), (int)entrySearch.getStart(), (int)entrySearch.getEnd(), (OrderByComparator)entrySearch.getOrderByComparator());
            entrySearch.setTotal(trashEntryList.getCount());
            trashEntries = trashEntryList.getOriginalTrashEntries();
            this._approximate = trashEntryList.isApproximate();
        }
        entrySearch.setResults(trashEntries);
        if (entrySearch.getTotal() == 0 && Validator.isNotNull((String)searchTerms.getKeywords())) {
            entrySearch.setEmptyResultsMessage(LanguageUtil.format((HttpServletRequest)this._request, (String)"no-entries-were-found-that-matched-the-keywords-x", (Object)("<strong>" + HtmlUtil.escape((String)searchTerms.getKeywords()) + "</strong>"), (boolean)false));
        }
        this._entrySearch = entrySearch;
        return this._entrySearch;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(TrashDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(TrashDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getInfoPanelNavigationItems() {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)themeDisplay.getURLCurrent());
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"details"));
                });
            }
        };
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        return this._keywords;
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
        return this._navigation;
    }

    public List<NavigationItem> getNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)TrashDisplayContext.this._liferayPortletResponse.createRenderURL());
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"entries"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"removed-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String navigation;
        String keywords;
        String displayStyle;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        long trashEntryId = this.getTrashEntryId();
        if (trashEntryId > 0L) {
            portletURL.setParameter("mvcPath", "/view_content.jsp");
            portletURL.setParameter("trashEntryId", String.valueOf(trashEntryId));
        }
        if (Validator.isNotNull((String)(displayStyle = this.getDisplayStyle()))) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(navigation = this.getNavigation()))) {
            portletURL.setParameter("navigation", navigation);
        }
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() throws PortalException {
        EntrySearch entrySearch = this.getEntrySearch();
        return entrySearch.getTotal();
    }

    public TrashEntry getTrashEntry() {
        String className;
        if (this._trashEntry != null) {
            return this._trashEntry;
        }
        long trashEntryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"trashEntryId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)this._request, (String)"classPK");
        if (trashEntryId > 0L) {
            this._trashEntry = TrashEntryLocalServiceUtil.fetchEntry((long)trashEntryId);
        } else if (classNameId > 0L && classPK > 0L && Validator.isNotNull((String)(className = PortalUtil.getClassName((long)classNameId)))) {
            this._trashEntry = TrashEntryLocalServiceUtil.fetchEntry((String)className, (long)classPK);
        }
        return this._trashEntry;
    }

    public long getTrashEntryId() {
        TrashEntry trashEntry = this.getTrashEntry();
        if (trashEntry != null) {
            return trashEntry.getEntryId();
        }
        return 0L;
    }

    public TrashHandler getTrashHandler() {
        if (this._trashHandler != null) {
            return this._trashHandler;
        }
        this._trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getClassName());
        return this._trashHandler;
    }

    public TrashRenderer getTrashRenderer() throws PortalException {
        if (this._trashRenderer != null) {
            return this._trashRenderer;
        }
        TrashHandler trashHandler = this.getTrashHandler();
        long classPK = this.getClassPK();
        if (classPK > 0L && trashHandler != null) {
            this._trashRenderer = trashHandler.getTrashRenderer(this.getClassPK());
        }
        return this._trashRenderer;
    }

    public String getViewContentRedirectURL() throws PortalException {
        String redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        if (Validator.isNull((String)redirect)) {
            TrashHandler trashHandler = this.getTrashHandler();
            ContainerModel parentContainerModel = trashHandler.getParentContainerModel(this.getClassPK());
            PortletURL redirectURL = this._liferayPortletResponse.createRenderURL();
            if (parentContainerModel != null && this.getClassNameId() > 0L) {
                String parentContainerModelClassName = parentContainerModel.getModelClassName();
                redirectURL.setParameter("mvcPath", "/view_content.jsp");
                redirectURL.setParameter("classNameId", String.valueOf(PortalUtil.getClassNameId((String)parentContainerModelClassName)));
                redirectURL.setParameter("classPK", String.valueOf(parentContainerModel.getContainerModelId()));
            }
            redirect = redirectURL.toString();
        }
        return redirect;
    }

    public List<ViewTypeItem> getViewTypeItems() {
        PortletURL portletURL = this._liferayPortletResponse.createActionURL();
        portletURL.setParameter("javax.portlet.action", "changeDisplayStyle");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._request));
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isApproximate() {
        return this._approximate;
    }

    public boolean isDescriptiveView() {
        return Objects.equals(this.getDisplayStyle(), "descriptive");
    }

    public boolean isIconView() {
        return Objects.equals(this.getDisplayStyle(), "icon");
    }

    public boolean isListView() {
        return Objects.equals(this.getDisplayStyle(), "list");
    }

    private List<DropdownItem> _getContentFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(TrashDisplayContext.this.getNavigation(), "all"));
                    dropdownItem.setHref(TrashDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(TrashDisplayContext.this.getNavigation(), "all"));
                    dropdownItem.setHref(TrashDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"all"));
                });
                for (TrashHandler trashHandler : TrashHandlerRegistryUtil.getTrashHandlers()) {
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(Objects.equals(TrashDisplayContext.this.getNavigation(), trashHandler.getClassName()));
                        dropdownItem.setHref(TrashDisplayContext.this.getPortletURL(), new Object[]{"navigation", trashHandler.getClassName()});
                        dropdownItem.setLabel(ResourceActionsUtil.getModelResource((Locale)themeDisplay.getLocale(), (String)trashHandler.getClassName()));
                    });
                }
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(TrashDisplayContext.this.getOrderByCol(), "removed-date"));
                    dropdownItem.setHref(TrashDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "removed-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)TrashDisplayContext.this._request, (String)"removed-date"));
                });
            }
        };
    }
}

