/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class TrashContainerModelDisplayContext {
    private String _backURL;
    private String _className;
    private Long _classNameId;
    private Long _classPK;
    private String _containerModelClassName;
    private Long _containerModelClassNameId;
    private Long _containerModelId;
    private String _containerModelName;
    private List<ContainerModel> _containerModels;
    private Integer _containerModelsCount;
    private String _eventName;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private Object[] _missingContainerMessageArguments;
    private String _redirect;
    private final HttpServletRequest _request;
    private SearchContainer _searchContainer;
    private Boolean _showBackIcon;
    private TrashHandler _trashHandler;
    private TrashRenderer _trashRenderer;

    public TrashContainerModelDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
    }

    public String getBackURL() {
        if (Validator.isNotNull((String)this._backURL)) {
            return this._backURL;
        }
        this._backURL = ParamUtil.getString((HttpServletRequest)this._request, (String)"backURL", (String)this.getRedirect());
        return this._backURL;
    }

    public String getClassName() {
        if (Validator.isNotNull((String)this._className)) {
            return this._className;
        }
        this._className = PortalUtil.getClassName((long)this.getClassNameId());
        return this._className;
    }

    public long getClassNameId() {
        if (this._classNameId != null) {
            return this._classNameId;
        }
        this._classNameId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"classNameId");
        return this._classNameId;
    }

    public long getClassPK() {
        if (this._classPK != null) {
            return this._classPK;
        }
        this._classPK = ParamUtil.getLong((HttpServletRequest)this._request, (String)"classPK");
        return this._classPK;
    }

    public String getContainerModelClassName() {
        if (Validator.isNotNull((String)this._containerModelClassName)) {
            return this._containerModelClassName;
        }
        this._containerModelClassName = PortalUtil.getClassName((long)this.getContainerModelClassNameId());
        return this._containerModelClassName;
    }

    public long getContainerModelClassNameId() {
        if (this._containerModelClassNameId != null) {
            return this._containerModelClassNameId;
        }
        String containerModelClassName = "";
        TrashHandler trashHandler = this.getTrashHandler();
        if (trashHandler != null) {
            containerModelClassName = trashHandler.getContainerModelClassName(this.getClassPK());
        }
        this._containerModelClassNameId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"containerModelClassNameId", (long)PortalUtil.getClassNameId((String)containerModelClassName));
        return this._containerModelClassNameId;
    }

    public long getContainerModelId() {
        if (this._containerModelId != null) {
            return this._containerModelId;
        }
        this._containerModelId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"containerModelId");
        return this._containerModelId;
    }

    public String getContainerModelName() {
        if (Validator.isNotNull((String)this._containerModelName)) {
            return this._containerModelName;
        }
        TrashHandler trashHandler = this.getTrashHandler();
        if (trashHandler != null) {
            this._containerModelName = trashHandler.getContainerModelName();
        }
        return this._containerModelName;
    }

    public List<ContainerModel> getContainerModels() throws PortalException {
        if (ListUtil.isNotEmpty(this._containerModels)) {
            return this._containerModels;
        }
        SearchContainer searchContainer = this.getSearchContainer();
        TrashHandler trashHandler = this.getTrashHandler();
        if (searchContainer != null && trashHandler != null) {
            this._containerModels = trashHandler.getContainerModels(this.getClassPK(), this.getContainerModelId(), searchContainer.getStart(), searchContainer.getEnd());
        }
        return this._containerModels;
    }

    public int getContainerModelsCount() throws PortalException {
        if (this._containerModelsCount != null) {
            return this._containerModelsCount;
        }
        int containerModelsCount = 0;
        TrashHandler trashHandler = this.getTrashHandler();
        if (trashHandler != null) {
            containerModelsCount = trashHandler.getContainerModelsCount(this.getClassPK(), this.getContainerModelId());
        }
        this._containerModelsCount = containerModelsCount;
        return this._containerModelsCount;
    }

    public PortletURL getContainerURL() {
        String currentURL = (String)this._request.getAttribute("CURRENT_URL");
        PortletURL containerURL = this._liferayPortletResponse.createRenderURL();
        containerURL.setParameter("mvcPath", "/view_container_model.jsp");
        containerURL.setParameter("redirect", this.getRedirect());
        containerURL.setParameter("backURL", currentURL);
        containerURL.setParameter("classNameId", String.valueOf(this.getClassNameId()));
        containerURL.setParameter("classPK", String.valueOf(this.getClassPK()));
        return containerURL;
    }

    public String getEventName() {
        if (Validator.isNotNull((String)this._eventName)) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._request, (String)"eventName", (String)(this._liferayPortletResponse.getNamespace() + "selectContainer"));
        return this._eventName;
    }

    public Object[] getMissingContainerMessageArguments() throws PortalException {
        if (this._missingContainerMessageArguments != null) {
            return this._missingContainerMessageArguments;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String trashRendererTitle = "";
        TrashRenderer trashRenderer = this.getTrashRenderer();
        if (trashRenderer != null) {
            trashRendererTitle = trashRenderer.getTitle(themeDisplay.getLocale());
        }
        this._missingContainerMessageArguments = new Object[]{LanguageUtil.get((HttpServletRequest)this._request, (String)this.getContainerModelName()), HtmlUtil.escape((String)trashRendererTitle)};
        return this._missingContainerMessageArguments;
    }

    public String getRedirect() {
        if (Validator.isNotNull((String)this._redirect)) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        return this._redirect;
    }

    public SearchContainer getSearchContainer() {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        PortletURL containerURL = this.getContainerURL();
        containerURL.setParameter("containerModelId", String.valueOf(this.getContainerModelId()));
        this._searchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, null, null, "cur", SearchContainer.DEFAULT_DELTA, containerURL, null, null);
        return this._searchContainer;
    }

    public TrashHandler getTrashHandler() {
        if (this._trashHandler != null) {
            return this._trashHandler;
        }
        this._trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getClassName());
        return this._trashHandler;
    }

    public TrashRenderer getTrashRenderer() throws PortalException {
        if (this._trashRenderer != null) {
            return this._trashRenderer;
        }
        TrashHandler trashHandler = this.getTrashHandler();
        if (trashHandler != null) {
            this._trashRenderer = trashHandler.getTrashRenderer(this.getClassPK());
        }
        return this._trashRenderer;
    }

    public boolean isShowBackIcon() throws PortalException {
        if (this._showBackIcon != null) {
            return this._showBackIcon;
        }
        TrashHandler containerTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getContainerModelClassName());
        ContainerModel containerModel = null;
        if (this.getContainerModelId() > 0L) {
            containerModel = containerTrashHandler.getContainerModel(this.getContainerModelId());
        }
        boolean showBackIcon = false;
        if (containerModel != null) {
            showBackIcon = true;
        }
        this._showBackIcon = showBackIcon;
        return this._showBackIcon;
    }
}

