/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.web.internal.dao.search;

import com.liferay.portal.kernel.dao.search.ResultRow;
import com.liferay.portal.kernel.dao.search.ResultRowSplitter;
import com.liferay.portal.kernel.dao.search.ResultRowSplitterEntry;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class TrashResultRowSplitter
implements ResultRowSplitter {
    public List<ResultRowSplitterEntry> split(List<ResultRow> resultRows) {
        ArrayList<ResultRowSplitterEntry> resultRowSplitterEntries = new ArrayList<ResultRowSplitterEntry>();
        ArrayList<ResultRow> trashContainedResultRows = new ArrayList<ResultRow>();
        ArrayList<ResultRow> trashContainerResultRows = new ArrayList<ResultRow>();
        String containerModelName = null;
        String containedModelName = null;
        for (ResultRow resultRow : resultRows) {
            TrashedModel trashedModel = (TrashedModel)resultRow.getObject();
            ClassedModel classedModel = (ClassedModel)trashedModel;
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)classedModel.getModelClassName());
            if (Validator.isNull(containerModelName) && Validator.isNull(containedModelName)) {
                containerModelName = trashHandler.getTrashContainerModelName();
                containedModelName = trashHandler.getTrashContainedModelName();
            }
            if (trashHandler.isContainerModel()) {
                trashContainerResultRows.add(resultRow);
                continue;
            }
            trashContainedResultRows.add(resultRow);
        }
        if (!trashContainerResultRows.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry(containerModelName, trashContainerResultRows));
        }
        if (!trashContainedResultRows.isEmpty()) {
            resultRowSplitterEntries.add(new ResultRowSplitterEntry(containedModelName, trashContainedResultRows));
        }
        return resultRowSplitterEntries;
    }
}

