/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.test.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalServiceUtil;
import com.liferay.trash.service.TrashEntryServiceUtil;
import com.liferay.trash.service.TrashVersionLocalServiceUtil;
import com.liferay.trash.test.util.WhenCanBeDuplicatedInTrash;
import com.liferay.trash.test.util.WhenHasDraftStatus;
import com.liferay.trash.test.util.WhenHasGrandParent;
import com.liferay.trash.test.util.WhenHasMyBaseModel;
import com.liferay.trash.test.util.WhenHasParent;
import com.liferay.trash.test.util.WhenHasRecentBaseModelCount;
import com.liferay.trash.test.util.WhenIsAssetableBaseModel;
import com.liferay.trash.test.util.WhenIsAssetableParentModel;
import com.liferay.trash.test.util.WhenIsIndexableBaseModel;
import com.liferay.trash.test.util.WhenIsMoveableFromTrashBaseModel;
import com.liferay.trash.test.util.WhenIsRestorableBaseModel;
import com.liferay.trash.test.util.WhenIsRestorableParentBaseModelFromTrash;
import com.liferay.trash.test.util.WhenIsUpdatableBaseModel;
import com.liferay.trash.test.util.WhenIsVersionableBaseModel;
import com.liferay.trash.test.util.WhenParentModelIsSameType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseTrashHandlerTestCase {
    protected BaseModel<?> baseModel;
    @DeleteAfterTestRun
    protected Group group;
    private static final String _TRASH_PREFIX = "/";

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
    }

    @Test
    public void testDeleteTrashVersions() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialTrashVersionsCount = TrashVersionLocalServiceUtil.getTrashVersionsCount();
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialTrashVersionsCount, (long)TrashVersionLocalServiceUtil.getTrashVersionsCount());
    }

    @Test
    public void testMoveBaseModelToTrash() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
        TrashEntry trashEntry = TrashEntryLocalServiceUtil.getEntry((String)this.getBaseModelClassName(), (long)this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        Assert.assertEquals((long)1L, (long)this.getDeletionSystemEventCount(trashHandler, trashEntry.getSystemEventSetKey()));
    }

    @Test
    public void testMoveBaseModelToTrashIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testMoveBaseModelToTrashIndexableAndReindex() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        this.reindex((ClassedModel)this.baseModel);
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testMoveBaseModelToTrashIndexableWithEqualsParentAndBaseModelClass() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testMoveBaseModelToTrashIndexableWithEqualsParentAndBaseModelClassAndReindex() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        this.reindex((ClassedModel)this.baseModel);
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testMoveBaseModelToTrashIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertFalse((boolean)whenIsAssetableBaseModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testMoveBaseModelToTrashStatusIsInTrash() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj()));
        Assert.assertEquals((long)8L, (long)workflowedModel.getStatus());
    }

    @Test
    public void testMoveBaseModelToTrashUniqueTitleNotChange() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        String uniqueTitle = this.getUniqueTitle(this.baseModel);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        if (uniqueTitle != null) {
            Assert.assertEquals((Object)uniqueTitle, (Object)this.getUniqueTitle(this.baseModel));
        }
    }

    @Test
    public void testTrashAndDeleteWithApprovedStatus() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)1L, (long)this.getDeletionSystemEventCount(trashHandler, -1L));
    }

    @Test
    public void testTrashAndDeleteWithApprovedStatusIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashAndDeleteWithApprovedStatusIndexableAndEqualsParentAndBaseModelClass() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashAndDeleteWithApprovedStatusIsNotFound() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertNull((Object)whenIsAssetableBaseModel.fetchAssetEntry((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashAndDeleteWithDraftStatus() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)1L, (long)this.getDeletionSystemEventCount(trashHandler, -1L));
    }

    @Test
    public void testTrashAndDeleteWithDraftStatusIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashAndDeleteWithDraftStatusIsNotFound() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertNull((Object)whenIsAssetableBaseModel.fetchAssetEntry((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashAndRestoreWithApprovedStatus() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)0L, (long)this.getDeletionSystemEventCount(trashHandler, -1L));
    }

    @Test
    public void testTrashAndRestoreWithApprovedStatusIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashAndRestoreWithApprovedStatusIndexableAndEqualsParentAndBaseModelClass() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 2), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashAndRestoreWithApprovedStatusIsVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertTrue((boolean)whenIsAssetableBaseModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashAndRestoreWithApprovedStatusRestoreStatus() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        int oldStatus = workflowedModel.getStatus();
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        Assert.assertEquals((long)oldStatus, (long)workflowedModel.getStatus());
    }

    @Test
    public void testTrashAndRestoreWithApprovedStatusRestoreUniqueTitle() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        String uniqueTitle = this.getUniqueTitle(this.baseModel);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        if (uniqueTitle != null) {
            Assert.assertEquals((Object)uniqueTitle, (Object)this.getUniqueTitle(this.baseModel));
        }
    }

    @Test
    public void testTrashAndRestoreWithDraftStatus() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)0L, (long)this.getDeletionSystemEventCount(trashHandler, -1L));
    }

    @Test
    public void testTrashAndRestoreWithDraftStatusIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashAndRestoreWithDraftStatusIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertFalse((boolean)whenIsAssetableBaseModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashAndRestoreWithDraftStatusRestoreStatus() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        int oldStatus = workflowedModel.getStatus();
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        Assert.assertEquals((long)oldStatus, (long)workflowedModel.getStatus());
    }

    @Test
    public void testTrashAndRestoreWithDraftStatusRestoreUniqueTitle() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addDraftBaseModel(parentBaseModel, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        String uniqueTitle = this.getUniqueTitle(this.baseModel);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        if (uniqueTitle != null) {
            Assert.assertEquals((Object)uniqueTitle, (Object)this.getUniqueTitle(this.baseModel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrashBaseModelAndDeleteWithParentIsNotRestorable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableBaseModel));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        try {
            this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
            this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
            this.deleteParentBaseModel(parentBaseModel, false);
            boolean restorable = trashHandler.isRestorable(this.getAssetClassPK((ClassedModel)this.baseModel).longValue());
            Assert.assertFalse((boolean)restorable);
        }
        finally {
            trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        }
    }

    @Test
    public void testTrashBaseModelAndParentAndDeleteGroupTrashEntries() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashEntryServiceUtil.deleteEntries((long)this.group.getGroupId());
        Assert.assertEquals((long)0L, (long)this.getTrashEntriesCount(this.group.getGroupId()));
        try {
            this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
            Assert.fail();
        }
        catch (NoSuchModelException noSuchModelException) {
            // empty catch block
        }
    }

    @Test
    public void testTrashBaseModelAndParentAndDeleteParent() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        parentTrashHandler.deleteTrashEntry(((Long)parentBaseModel.getPrimaryKeyObj()).longValue());
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialTrashEntriesCount, (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashBaseModelAndParentAndDeleteParentNoMoveableFromTrash() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeFalse((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        parentTrashHandler.deleteTrashEntry(((Long)parentBaseModel.getPrimaryKeyObj()).longValue());
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        try {
            this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
            Assert.fail();
        }
        catch (NoSuchModelException noSuchModelException) {
            // empty catch block
        }
        Assert.assertEquals((long)initialTrashEntriesCount, (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashBaseModelAndParentAndRestore() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)(initialTrashEntriesCount + 2), (long)this.getTrashEntriesCount(this.group.getGroupId()));
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        if (Objects.equals(this.getBaseModelClassName(), whenHasParent.getParentBaseModelClassName())) {
            Assert.assertEquals((long)0L, (long)parentTrashHandler.getTrashContainedModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
            Assert.assertEquals((long)1L, (long)parentTrashHandler.getTrashContainerModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
        } else {
            Assert.assertEquals((long)1L, (long)parentTrashHandler.getTrashContainedModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
            Assert.assertEquals((long)0L, (long)parentTrashHandler.getTrashContainerModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
        }
    }

    @Test
    public void testTrashBaseModelAndParentAndRestoreModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsMoveableFromTrashBaseModel whenIsMoveableFromTrashBaseModel = (WhenIsMoveableFromTrashBaseModel)((Object)this);
        BaseModel<?> newParentBaseModel = whenIsMoveableFromTrashBaseModel.moveBaseModelFromTrash((ClassedModel)this.baseModel, this.group, serviceContext);
        Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)this.getNotInTrashBaseModelsCount(newParentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashBaseModelAndParentAndRestoreModelIsVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsMoveableFromTrashBaseModel whenIsMoveableFromTrashBaseModel = (WhenIsMoveableFromTrashBaseModel)((Object)this);
        whenIsMoveableFromTrashBaseModel.moveBaseModelFromTrash((ClassedModel)this.baseModel, this.group, serviceContext);
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertTrue((boolean)whenIsAssetableBaseModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashBaseModelAndParentIsInContainerBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertTrue((boolean)this.isInTrashContainer((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashBaseModelAndParentIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertFalse((boolean)whenIsAssetableBaseModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrashBaseModelAndTrashParentAndDeleteParentIsNotRestorable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        try {
            this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
            this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
            whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
            TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
            parentTrashHandler.deleteTrashEntry(((Long)parentBaseModel.getPrimaryKeyObj()).longValue());
            boolean restorable = trashHandler.isRestorable(this.getAssetClassPK((ClassedModel)this.baseModel).longValue());
            Assert.assertFalse((boolean)restorable);
        }
        finally {
            trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        }
    }

    @Test
    public void testTrashBaseModelAndTrashParentIsNotRestorable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        boolean restorable = trashHandler.isRestorable(this.getAssetClassPK((ClassedModel)this.baseModel).longValue());
        Assert.assertFalse((boolean)restorable);
    }

    @Test
    public void testTrashBaseModelIsInTrashContainer() throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertFalse((boolean)this.isInTrashContainer((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashBaseModelWithParentIsRestorable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableBaseModel));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        boolean restorable = trashHandler.isRestorable(this.getAssetClassPK((ClassedModel)this.baseModel).longValue());
        Assert.assertTrue((boolean)restorable);
    }

    @Test
    public void testTrashDuplicate() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenCanBeDuplicatedInTrash));
        WhenCanBeDuplicatedInTrash whenCanBeDuplicatedInTrash = (WhenCanBeDuplicatedInTrash)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertTrue((boolean)this.isValidTrashTitle(whenCanBeDuplicatedInTrash.getBaseModelName((ClassedModel)this.baseModel)));
        BaseModel<?> duplicateBaseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.moveBaseModelToTrash((Long)duplicateBaseModel.getPrimaryKeyObj());
        duplicateBaseModel = this.getBaseModel((Long)duplicateBaseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 2), (long)this.getTrashEntriesCount(this.group.getGroupId()));
        String duplicateBaseModelName = whenCanBeDuplicatedInTrash.getBaseModelName((ClassedModel)duplicateBaseModel);
        Assert.assertTrue((boolean)this.isValidTrashTitle(duplicateBaseModelName));
    }

    @Test
    public void testTrashGrandparentBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasGrandParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> grandparentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(grandparentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, (Long)grandparentBaseModel.getPrimaryKeyObj(), serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        if (Objects.equals(this.getBaseModelClassName(), whenHasParent.getParentBaseModelClassName())) {
            Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)this.getNotInTrashBaseModelsCount(grandparentBaseModel));
        } else {
            Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(grandparentBaseModel));
        }
        whenHasParent.moveParentBaseModelToTrash((Long)grandparentBaseModel.getPrimaryKeyObj());
        Assert.assertTrue((boolean)this.isInTrashContainer((ClassedModel)this.baseModel));
        Assert.assertTrue((boolean)this.isInTrashContainer((ClassedModel)parentBaseModel));
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(grandparentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashGrandparentBaseModelAndRestoreParentModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasGrandParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> grandparentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, (Long)grandparentBaseModel.getPrimaryKeyObj(), serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)grandparentBaseModel.getPrimaryKeyObj());
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        parentTrashHandler.restoreTrashEntry(TestPropsValues.getUserId(), ((Long)grandparentBaseModel.getPrimaryKeyObj()).longValue());
        Assert.assertEquals((long)initialTrashEntriesCount, (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashGrandparentBaseModelAndRestoreParentModelIsNotInTrashContainer() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasGrandParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> grandparentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, (Long)grandparentBaseModel.getPrimaryKeyObj(), serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)grandparentBaseModel.getPrimaryKeyObj());
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        parentTrashHandler.restoreTrashEntry(TestPropsValues.getUserId(), ((Long)grandparentBaseModel.getPrimaryKeyObj()).longValue());
        Assert.assertFalse((boolean)this.isInTrashContainer((ClassedModel)this.baseModel));
        Assert.assertFalse((boolean)this.isInTrashContainer((ClassedModel)parentBaseModel));
    }

    @Test
    public void testTrashGrandparentBaseModelAndRestoreParentModelIsVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasGrandParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> grandparentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, (Long)grandparentBaseModel.getPrimaryKeyObj(), serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)grandparentBaseModel.getPrimaryKeyObj());
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        parentTrashHandler.restoreTrashEntry(TestPropsValues.getUserId(), ((Long)grandparentBaseModel.getPrimaryKeyObj()).longValue());
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertTrue((boolean)whenIsAssetableBaseModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashGrandparentBaseModelAndRestoreParentModelIsVisibleParent() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasGrandParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableParentModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> grandparentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, (Long)grandparentBaseModel.getPrimaryKeyObj(), serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)grandparentBaseModel.getPrimaryKeyObj());
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        parentTrashHandler.restoreTrashEntry(TestPropsValues.getUserId(), ((Long)grandparentBaseModel.getPrimaryKeyObj()).longValue());
        WhenIsAssetableParentModel whenIsAssetableParentModel = (WhenIsAssetableParentModel)((Object)this);
        Assert.assertTrue((boolean)whenIsAssetableParentModel.isAssetEntryVisible((ClassedModel)parentBaseModel, this.getAssetClassPK((ClassedModel)parentBaseModel)));
    }

    @Test
    public void testTrashGrandparentBaseModelIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasGrandParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> grandparentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, (Long)grandparentBaseModel.getPrimaryKeyObj(), serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)grandparentBaseModel.getPrimaryKeyObj());
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertFalse((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashGrandparentBaseModelIsNotVisibleParent() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasGrandParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableParentModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> grandparentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, (Long)grandparentBaseModel.getPrimaryKeyObj(), serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)grandparentBaseModel.getPrimaryKeyObj());
        WhenIsAssetableParentModel whenIsAssetableParentModel = (WhenIsAssetableParentModel)((Object)this);
        Assert.assertFalse((boolean)whenIsAssetableParentModel.isAssetEntryVisible((ClassedModel)parentBaseModel, this.getAssetClassPK((ClassedModel)parentBaseModel)));
    }

    @Test
    public void testTrashIsRestorableBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableBaseModel));
        this.baseModel = this.addBaseModelWithWorkflow(ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId()));
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        boolean restorable = trashHandler.isRestorable(this.getAssetClassPK((ClassedModel)this.baseModel).longValue());
        Assert.assertTrue((boolean)restorable);
    }

    @Test
    public void testTrashMyBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasMyBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasMyBaseModel whenHasMyBaseModel = (WhenHasMyBaseModel)((Object)this);
        int initialBaseModelsCount = whenHasMyBaseModel.getMineBaseModelsCount(this.group.getGroupId(), TestPropsValues.getUserId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.addBaseModel(parentBaseModel, serviceContext);
        Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)whenHasMyBaseModel.getMineBaseModelsCount(this.group.getGroupId(), TestPropsValues.getUserId()));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsCount, (long)whenHasMyBaseModel.getMineBaseModelsCount(this.group.getGroupId(), TestPropsValues.getUserId()));
    }

    @Test
    public void testTrashParent() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        if (Objects.equals(this.getBaseModelClassName(), whenHasParent.getParentBaseModelClassName())) {
            Assert.assertEquals((long)0L, (long)parentTrashHandler.getTrashContainedModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
            Assert.assertEquals((long)1L, (long)parentTrashHandler.getTrashContainerModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
        } else {
            Assert.assertEquals((long)1L, (long)parentTrashHandler.getTrashContainedModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
            Assert.assertEquals((long)0L, (long)parentTrashHandler.getTrashContainerModelsCount(((Long)parentBaseModel.getPrimaryKeyObj()).longValue()));
        }
    }

    @Test(expected=TrashEntryException.class)
    public void testTrashParentAndBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableBaseModel));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
    }

    @Test
    public void testTrashParentAndDeleteGroupTrashEntries() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashEntryServiceUtil.deleteEntries((long)this.group.getGroupId());
        Assert.assertEquals((long)0L, (long)this.getTrashEntriesCount(this.group.getGroupId()));
        try {
            this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
            Assert.fail();
        }
        catch (NoSuchModelException noSuchModelException) {
            // empty catch block
        }
    }

    @Test
    public void testTrashParentAndDeleteParent() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashHandler parentTrashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)whenHasParent.getParentBaseModelClassName());
        parentTrashHandler.deleteTrashEntry(((Long)parentBaseModel.getPrimaryKeyObj()).longValue());
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        try {
            this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
            Assert.fail();
        }
        catch (NoSuchModelException noSuchModelException) {
            // empty catch block
        }
        Assert.assertEquals((long)initialTrashEntriesCount, (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashParentAndRestoreBaseModelIsVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsMoveableFromTrashBaseModel whenIsMoveableFromTrashBaseModel = (WhenIsMoveableFromTrashBaseModel)((Object)this);
        whenIsMoveableFromTrashBaseModel.moveBaseModelFromTrash((ClassedModel)this.baseModel, this.group, serviceContext);
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertTrue((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashParentAndRestoreIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsMoveableFromTrashBaseModel whenIsMoveableFromTrashBaseModel = (WhenIsMoveableFromTrashBaseModel)((Object)this);
        whenIsMoveableFromTrashBaseModel.moveBaseModelFromTrash((ClassedModel)this.baseModel, this.group, serviceContext);
        if (this.isBaseModelContainerModel()) {
            Assert.assertEquals((long)(initialBaseModelsSearchCount + 2), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        } else {
            Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        }
    }

    @Test(expected=RestoreEntryException.class)
    public void testTrashParentAndRestoreParentAndBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableParentBaseModelFromTrash));
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsRestorableParentBaseModelFromTrash whenIsRestorableParentBaseModelFromTrash = (WhenIsRestorableParentBaseModelFromTrash)((Object)this);
        whenIsRestorableParentBaseModelFromTrash.restoreParentBaseModelFromTrash((Long)parentBaseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashParentIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
    }

    @Test
    public void testTrashParentIndexableAndReindex() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        this.reindex((ClassedModel)this.baseModel);
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
    }

    @Test
    public void testTrashParentIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertFalse((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashParentWithBaseModelIsInTrashContainer() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertTrue((boolean)this.isInTrashContainer((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashParentWithBaseModelIsIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertFalse((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashRecentBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenHasRecentBaseModelCount));
        WhenHasRecentBaseModelCount whenHasRecentBaseModelCount = (WhenHasRecentBaseModelCount)((Object)this);
        int initialBaseModelsCount = whenHasRecentBaseModelCount.getRecentBaseModelsCount(this.group.getGroupId());
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.addBaseModel(parentBaseModel, serviceContext);
        Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)whenHasRecentBaseModelCount.getRecentBaseModelsCount(this.group.getGroupId()));
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsCount, (long)whenHasRecentBaseModelCount.getRecentBaseModelsCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashVersionBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashVersionBaseModelAndDelete() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialBaseModelsCount, (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)initialTrashEntriesCount, (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashVersionBaseModelAndDeleteIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelAndDeleteIndexableWithEqualsParentAndBaseModelClass() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelAndDeleteIsNotFound() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.deleteTrashEntry(this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        WhenIsAssetableBaseModel whenIsAssetableBaseModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertNull((Object)whenIsAssetableBaseModel.fetchAssetEntry((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashVersionBaseModelAndRestore() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)this.getNotInTrashBaseModelsCount(parentBaseModel));
        Assert.assertEquals((long)initialTrashEntriesCount, (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashVersionBaseModelAndRestoreIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelAndRestoreIndexableWithEqualsParentAndBaseModelClass() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 2), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelAndRestoreIsVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)this.getBaseModelClassName());
        trashHandler.restoreTrashEntry(TestPropsValues.getUserId(), this.getTrashEntryClassPK((ClassedModel)this.baseModel));
        Assert.assertTrue((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashVersionBaseModelIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelIndexableAndReindex() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeFalse((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        this.reindex((ClassedModel)this.baseModel);
        Assert.assertEquals((long)initialBaseModelsSearchCount, (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelIndexableWithEqualsParentAndBaseModelClass() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelIndexableWithEqualsParentAndBaseModelClassAndReindex() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenParentModelIsSameType));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        this.reindex((ClassedModel)this.baseModel);
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)(initialTrashEntriesSearchCount + 1), (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionBaseModelIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        this.moveBaseModelToTrash((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertFalse((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashVersionParentBaseModel() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsVersionableBaseModel));
        WhenIsVersionableBaseModel whenIsVersionableBaseModel = (WhenIsVersionableBaseModel)((Object)this);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsVersionableBaseModel.expireBaseModel(this.baseModel, serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        ArrayList<Integer> originalStatuses = new ArrayList<Integer>();
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(1);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
        Assert.assertTrue((boolean)this.isInTrashContainer((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashVersionParentBaseModelAndCustomRestore() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeFalse((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsRestorableParentBaseModelFromTrash));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsVersionableBaseModel));
        WhenIsVersionableBaseModel whenIsVersionableBaseModel = (WhenIsVersionableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsVersionableBaseModel.expireBaseModel(this.baseModel, serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        ArrayList<Integer> originalStatuses = new ArrayList<Integer>();
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(1);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsRestorableParentBaseModelFromTrash whenIsRestorableParentBaseModelFromTrash = (WhenIsRestorableParentBaseModelFromTrash)((Object)this);
        whenIsRestorableParentBaseModelFromTrash.restoreParentBaseModelFromTrash((Long)parentBaseModel.getPrimaryKeyObj());
        List<? extends WorkflowedModel> childrenWorkflowedModels = whenIsRestorableParentBaseModelFromTrash.getChildrenWorkflowedModels(parentBaseModel);
        for (int i = 1; i <= childrenWorkflowedModels.size(); ++i) {
            WorkflowedModel childrenWorkflowedModel = childrenWorkflowedModels.get(i - 1);
            int originalStatus = (Integer)originalStatuses.get(childrenWorkflowedModels.size() - i);
            Assert.assertEquals((long)originalStatus, (long)childrenWorkflowedModel.getStatus());
        }
    }

    @Test
    public void testTrashVersionParentBaseModelAndRestore() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsVersionableBaseModel));
        WhenIsVersionableBaseModel whenIsVersionableBaseModel = (WhenIsVersionableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        int initialBaseModelsCount = this.getNotInTrashBaseModelsCount(parentBaseModel);
        int initialTrashEntriesCount = this.getTrashEntriesCount(this.group.getGroupId());
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsVersionableBaseModel.expireBaseModel(this.baseModel, serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        ArrayList<Integer> originalStatuses = new ArrayList<Integer>();
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(1);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsMoveableFromTrashBaseModel whenIsMoveableFromTrashBaseModel = (WhenIsMoveableFromTrashBaseModel)((Object)this);
        BaseModel<?> newParentBaseModel = whenIsMoveableFromTrashBaseModel.moveBaseModelFromTrash((ClassedModel)this.baseModel, this.group, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertEquals((long)(initialBaseModelsCount + 1), (long)this.getNotInTrashBaseModelsCount(newParentBaseModel));
        Assert.assertEquals((long)(initialTrashEntriesCount + 1), (long)this.getTrashEntriesCount(this.group.getGroupId()));
    }

    @Test
    public void testTrashVersionParentBaseModelAndRestoreIsNotInTrashContainer() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsVersionableBaseModel));
        WhenIsVersionableBaseModel whenIsVersionableBaseModel = (WhenIsVersionableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsVersionableBaseModel.expireBaseModel(this.baseModel, serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        ArrayList<Integer> originalStatuses = new ArrayList<Integer>();
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(1);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsMoveableFromTrashBaseModel whenIsMoveableFromTrashBaseModel = (WhenIsMoveableFromTrashBaseModel)((Object)this);
        whenIsMoveableFromTrashBaseModel.moveBaseModelFromTrash((ClassedModel)this.baseModel, this.group, serviceContext);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertFalse((boolean)this.isInTrashContainer((ClassedModel)this.baseModel));
    }

    @Test
    public void testTrashVersionParentBaseModelAndRestoreIsVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsMoveableFromTrashBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsVersionableBaseModel));
        WhenIsVersionableBaseModel whenIsVersionableBaseModel = (WhenIsVersionableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsVersionableBaseModel.expireBaseModel(this.baseModel, serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        ArrayList<Integer> originalStatuses = new ArrayList<Integer>();
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(1);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsMoveableFromTrashBaseModel whenIsMoveableFromTrashBaseModel = (WhenIsMoveableFromTrashBaseModel)((Object)this);
        whenIsMoveableFromTrashBaseModel.moveBaseModelFromTrash((ClassedModel)this.baseModel, this.group, serviceContext);
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        this.baseModel = this.getBaseModel((Long)this.baseModel.getPrimaryKeyObj());
        Assert.assertTrue((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    @Test
    public void testTrashVersionParentBaseModelIndexable() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenIsIndexableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsVersionableBaseModel));
        WhenIsIndexableBaseModel whenIsIndexableBaseModel = (WhenIsIndexableBaseModel)((Object)this);
        int initialBaseModelsSearchCount = whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId());
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        int initialTrashEntriesSearchCount = whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext);
        WhenIsVersionableBaseModel whenIsVersionableBaseModel = (WhenIsVersionableBaseModel)((Object)this);
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsVersionableBaseModel.expireBaseModel(this.baseModel, serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        ArrayList<Integer> originalStatuses = new ArrayList<Integer>();
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(1);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        Assert.assertEquals((long)(initialBaseModelsSearchCount + 1), (long)whenIsIndexableBaseModel.searchBaseModelsCount(this.getBaseModelClass(), this.group.getGroupId()));
        Assert.assertEquals((long)initialTrashEntriesSearchCount, (long)whenIsIndexableBaseModel.searchTrashEntriesCount(whenIsIndexableBaseModel.getSearchKeywords(), serviceContext));
    }

    @Test
    public void testTrashVersionParentBaseModelIsNotVisible() throws Exception {
        Assume.assumeTrue((boolean)(this instanceof WhenHasParent));
        Assume.assumeTrue((boolean)(this instanceof WhenIsAssetableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsUpdatableBaseModel));
        Assume.assumeTrue((boolean)(this instanceof WhenIsVersionableBaseModel));
        WhenIsVersionableBaseModel whenIsVersionableBaseModel = (WhenIsVersionableBaseModel)((Object)this);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        this.baseModel = this.addBaseModel(parentBaseModel, serviceContext);
        this.baseModel = whenIsVersionableBaseModel.expireBaseModel(this.baseModel, serviceContext);
        WhenIsUpdatableBaseModel whenIsUpdatableBaseModel = (WhenIsUpdatableBaseModel)((Object)this);
        WorkflowedModel workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        ArrayList<Integer> originalStatuses = new ArrayList<Integer>();
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(1);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        serviceContext.setWorkflowAction(2);
        this.baseModel = whenIsUpdatableBaseModel.updateBaseModel((Long)this.baseModel.getPrimaryKeyObj(), serviceContext);
        WhenHasParent whenHasParent = (WhenHasParent)((Object)this);
        workflowedModel = this.getWorkflowedModel((ClassedModel)this.baseModel);
        originalStatuses.add(workflowedModel.getStatus());
        whenHasParent.moveParentBaseModelToTrash((Long)parentBaseModel.getPrimaryKeyObj());
        WhenIsAssetableBaseModel whenIsAssetableModel = (WhenIsAssetableBaseModel)((Object)this);
        Assert.assertFalse((boolean)whenIsAssetableModel.isAssetEntryVisible((ClassedModel)this.baseModel, this.getAssetClassPK((ClassedModel)this.baseModel)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel<?> addBaseModel(BaseModel<?> parentBaseModel, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            BaseModel<?> baseModel = this.addBaseModelWithWorkflow(parentBaseModel, serviceContext);
            return baseModel;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    protected abstract BaseModel<?> addBaseModelWithWorkflow(BaseModel<?> var1, ServiceContext var2) throws Exception;

    protected BaseModel<?> addBaseModelWithWorkflow(ServiceContext serviceContext) throws Exception {
        BaseModel<?> parentBaseModel = this.getParentBaseModel(this.group, serviceContext);
        return this.addBaseModelWithWorkflow(parentBaseModel, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel<?> addDraftBaseModel(BaseModel<?> parentBaseModel, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            Assume.assumeTrue((boolean)(this instanceof WhenHasDraftStatus));
            WhenHasDraftStatus whenHasDraftStatus = (WhenHasDraftStatus)((Object)this);
            BaseModel<?> baseModel = whenHasDraftStatus.addDraftBaseModelWithWorkflow(parentBaseModel, serviceContext);
            return baseModel;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    protected void deleteParentBaseModel(BaseModel<?> parentBaseModel, boolean includeTrashedEntries) throws Exception {
    }

    protected Long getAssetClassPK(ClassedModel classedModel) {
        return (Long)classedModel.getPrimaryKeyObj();
    }

    protected abstract BaseModel<?> getBaseModel(long var1) throws Exception;

    protected abstract Class<?> getBaseModelClass();

    protected String getBaseModelClassName() {
        Class<?> clazz = this.getBaseModelClass();
        return clazz.getName();
    }

    protected long getDeletionSystemEventCount(TrashHandler trashHandler, long systemEventSetKey) throws Exception {
        long systemEventClassNameId = PortalUtil.getClassNameId((String)trashHandler.getSystemEventClassName());
        ActionableDynamicQuery actionableDynamicQuery = SystemEventLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)systemEventClassNameId));
            if (systemEventSetKey > 0L) {
                Property systemEventSetKeyProperty = PropertyFactoryUtil.forName((String)"systemEventSetKey");
                dynamicQuery.add(systemEventSetKeyProperty.eq((Object)systemEventSetKey));
            }
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.eq((Object)1));
        });
        actionableDynamicQuery.setGroupId(this.group.getGroupId());
        return actionableDynamicQuery.performCount();
    }

    protected abstract int getNotInTrashBaseModelsCount(BaseModel<?> var1) throws Exception;

    protected BaseModel<?> getParentBaseModel(Group group, long parentBaseModelId, ServiceContext serviceContext) throws Exception {
        return group;
    }

    protected BaseModel<?> getParentBaseModel(Group group, ServiceContext serviceContext) throws Exception {
        return group;
    }

    protected int getTrashEntriesCount(long groupId) throws Exception {
        return TrashEntryLocalServiceUtil.getEntriesCount((long)groupId);
    }

    protected long getTrashEntryClassPK(ClassedModel classedModel) {
        return (Long)classedModel.getPrimaryKeyObj();
    }

    protected abstract String getUniqueTitle(BaseModel<?> var1);

    protected WorkflowedModel getWorkflowedModel(ClassedModel baseModel) throws Exception {
        return (WorkflowedModel)baseModel;
    }

    protected boolean isBaseModelContainerModel() {
        return this.baseModel instanceof ContainerModel;
    }

    protected boolean isInTrashContainer(ClassedModel classedModel) throws Exception {
        if (classedModel instanceof TrashedModel) {
            TrashedModel trashedModel = (TrashedModel)classedModel;
            return trashedModel.isInTrashContainer();
        }
        return false;
    }

    protected boolean isValidTrashTitle(String title) {
        return title.startsWith(_TRASH_PREFIX);
    }

    protected abstract void moveBaseModelToTrash(long var1) throws Exception;

    protected void reindex(ClassedModel classedModel) throws Exception {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)classedModel.getModelClassName());
        long classPK = (Long)classedModel.getPrimaryKeyObj();
        indexer.reindex(classedModel.getModelClassName(), classPK);
    }
}

