/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.trash.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the TrashEntry service. Represents a row in the &quot;TrashEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.trash.model.impl.TrashEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.trash.model.impl.TrashEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see TrashEntry
 * @generated
 */
@ProviderType
public interface TrashEntryModel
	extends AttachedModel, BaseModel<TrashEntry>, CTModel<TrashEntry>,
			MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a trash entry model instance should use the {@link TrashEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this trash entry.
	 *
	 * @return the primary key of this trash entry
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this trash entry.
	 *
	 * @param primaryKey the primary key of this trash entry
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this trash entry.
	 *
	 * @return the mvcc version of this trash entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this trash entry.
	 *
	 * @param mvccVersion the mvcc version of this trash entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this trash entry.
	 *
	 * @return the ct collection ID of this trash entry
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this trash entry.
	 *
	 * @param ctCollectionId the ct collection ID of this trash entry
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the entry ID of this trash entry.
	 *
	 * @return the entry ID of this trash entry
	 */
	public long getEntryId();

	/**
	 * Sets the entry ID of this trash entry.
	 *
	 * @param entryId the entry ID of this trash entry
	 */
	public void setEntryId(long entryId);

	/**
	 * Returns the group ID of this trash entry.
	 *
	 * @return the group ID of this trash entry
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this trash entry.
	 *
	 * @param groupId the group ID of this trash entry
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this trash entry.
	 *
	 * @return the company ID of this trash entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this trash entry.
	 *
	 * @param companyId the company ID of this trash entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this trash entry.
	 *
	 * @return the user ID of this trash entry
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this trash entry.
	 *
	 * @param userId the user ID of this trash entry
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this trash entry.
	 *
	 * @return the user uuid of this trash entry
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this trash entry.
	 *
	 * @param userUuid the user uuid of this trash entry
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this trash entry.
	 *
	 * @return the user name of this trash entry
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this trash entry.
	 *
	 * @param userName the user name of this trash entry
	 */
	public void setUserName(String userName);

	/**
	 * Returns the create date of this trash entry.
	 *
	 * @return the create date of this trash entry
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this trash entry.
	 *
	 * @param createDate the create date of this trash entry
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the fully qualified class name of this trash entry.
	 *
	 * @return the fully qualified class name of this trash entry
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this trash entry.
	 *
	 * @return the class name ID of this trash entry
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this trash entry.
	 *
	 * @param classNameId the class name ID of this trash entry
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this trash entry.
	 *
	 * @return the class pk of this trash entry
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this trash entry.
	 *
	 * @param classPK the class pk of this trash entry
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the system event set key of this trash entry.
	 *
	 * @return the system event set key of this trash entry
	 */
	public long getSystemEventSetKey();

	/**
	 * Sets the system event set key of this trash entry.
	 *
	 * @param systemEventSetKey the system event set key of this trash entry
	 */
	public void setSystemEventSetKey(long systemEventSetKey);

	/**
	 * Returns the type settings of this trash entry.
	 *
	 * @return the type settings of this trash entry
	 */
	@AutoEscape
	public String getTypeSettings();

	/**
	 * Sets the type settings of this trash entry.
	 *
	 * @param typeSettings the type settings of this trash entry
	 */
	public void setTypeSettings(String typeSettings);

	/**
	 * Returns the status of this trash entry.
	 *
	 * @return the status of this trash entry
	 */
	public int getStatus();

	/**
	 * Sets the status of this trash entry.
	 *
	 * @param status the status of this trash entry
	 */
	public void setStatus(int status);

	@Override
	public TrashEntry cloneWithOriginalValues();

}