/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.base.SyncDLObjectLocalServiceBaseImpl;
import com.liferay.sync.service.internal.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.util.SyncHelper;
import java.util.Date;
import java.util.List;

public class SyncDLObjectLocalServiceImpl
extends SyncDLObjectLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SyncDLObjectLocalServiceImpl.class);
    @ServiceReference(type=SyncHelper.class)
    private SyncHelper _syncHelper;

    @Deprecated
    public SyncDLObject addSyncDLObject(long companyId, long userId, String userName, long modifiedTime, long repositoryId, long parentFolderId, String treePath, String name, String extension, String mimeType, String description, String changeLog, String extraSettings, String version, long versionId, long size, String checksum, String event, Date lockExpirationDate, long lockUserId, String lockUserName, String type, long typePK, String typeUuid) throws PortalException {
        return this.addSyncDLObject(companyId, userId, userName, modifiedTime, repositoryId, parentFolderId, treePath, name, extension, mimeType, description, changeLog, extraSettings, version, versionId, size, checksum, event, "", lockExpirationDate, lockUserId, lockUserName, type, typePK, typeUuid);
    }

    public SyncDLObject addSyncDLObject(long companyId, long userId, String userName, long modifiedTime, long repositoryId, long parentFolderId, String treePath, String name, String extension, String mimeType, String description, String changeLog, String extraSettings, String version, long versionId, long size, String checksum, String event, String lanTokenKey, Date lockExpirationDate, long lockUserId, String lockUserName, String type, long typePK, String typeUuid) throws PortalException {
        SyncDLObject parentFolderSyncDLObject;
        String parentFolderExtension;
        if (!this.isDefaultRepository(parentFolderId)) {
            return null;
        }
        SyncDLObject syncDLObject = this.syncDLObjectPersistence.fetchByT_T(type, typePK);
        if (syncDLObject == null) {
            SyncDLObject approvedSyncDLObject;
            long syncDLObjectId = this.counterLocalService.increment();
            syncDLObject = this.syncDLObjectPersistence.create(syncDLObjectId);
            syncDLObject.setCompanyId(companyId);
            syncDLObject.setCreateTime(modifiedTime);
            syncDLObject.setRepositoryId(repositoryId);
            syncDLObject.setType(type);
            syncDLObject.setTypePK(typePK);
            syncDLObject.setTypeUuid(typeUuid);
            if (type.equals("privateWorkingCopy") && (approvedSyncDLObject = this.syncDLObjectPersistence.fetchByT_T("file", typePK)) != null) {
                approvedSyncDLObject.setModifiedTime(modifiedTime);
                approvedSyncDLObject.setLockExpirationDate(lockExpirationDate);
                approvedSyncDLObject.setLockUserId(lockUserId);
                approvedSyncDLObject.setLockUserName(lockUserName);
                this.syncDLObjectPersistence.update((BaseModel)approvedSyncDLObject);
            }
        } else {
            SyncDLObject approvedSyncDLObject;
            if (syncDLObject.getModifiedTime() >= modifiedTime) {
                return null;
            }
            if (type.equals("file")) {
                DLFileEntry dlFileEntry;
                SyncDLObject pwcSyncDLObject = this.syncDLObjectPersistence.fetchByT_T("privateWorkingCopy", typePK);
                if (!(pwcSyncDLObject == null || (dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(typePK)) != null && dlFileEntry.isCheckedOut())) {
                    this.syncDLObjectPersistence.remove((BaseModel)pwcSyncDLObject);
                }
            } else if (type.equals("privateWorkingCopy") && (event.equals("restore") || event.equals("trash")) && (approvedSyncDLObject = this.syncDLObjectPersistence.fetchByT_T("file", typePK)) != null) {
                approvedSyncDLObject.setEvent(event);
                this.syncDLObjectPersistence.update((BaseModel)approvedSyncDLObject);
            }
        }
        syncDLObject.setUserId(userId);
        syncDLObject.setUserName(userName);
        syncDLObject.setModifiedTime(modifiedTime);
        syncDLObject.setParentFolderId(parentFolderId);
        syncDLObject.setTreePath(treePath);
        syncDLObject.setName(name);
        syncDLObject.setExtension(extension);
        syncDLObject.setMimeType(mimeType);
        syncDLObject.setDescription(description);
        syncDLObject.setChangeLog(changeLog);
        syncDLObject.setVersion(version);
        syncDLObject.setVersionId(versionId);
        syncDLObject.setSize(size);
        syncDLObject.setChecksum(checksum);
        syncDLObject.setEvent(event);
        syncDLObject.setLanTokenKey(lanTokenKey);
        if (event.equals("move")) {
            syncDLObject.setLastPermissionChangeDate(new Date());
        }
        syncDLObject.setLockExpirationDate(lockExpirationDate);
        syncDLObject.setLockUserId(lockUserId);
        syncDLObject.setLockUserName(lockUserName);
        syncDLObject = (SyncDLObject)this.syncDLObjectPersistence.update((BaseModel)syncDLObject);
        if (type.equals("file") && ArrayUtil.contains((Object[])SyncServiceConfigurationValues.SYNC_MAC_PACKAGE_METADATA_FILE_NAMES, (Object)syncDLObject.getName()) && ArrayUtil.contains((Object[])SyncServiceConfigurationValues.SYNC_MAC_PACKAGE_FOLDER_EXTENSIONS, (Object)(parentFolderExtension = FileUtil.getExtension((String)(parentFolderSyncDLObject = this.syncDLObjectPersistence.fetchByT_T("folder", syncDLObject.getParentFolderId())).getName())))) {
            JSONObject extraSettingsJSONObject = JSONFactoryUtil.createJSONObject((String)parentFolderSyncDLObject.getExtraSettings());
            extraSettingsJSONObject.put("macPackage", true);
            parentFolderSyncDLObject.setExtraSettings(extraSettingsJSONObject.toString());
            this.syncDLObjectPersistence.update((BaseModel)parentFolderSyncDLObject);
        }
        if (type.equals("folder")) {
            if (Validator.isNull((String)treePath)) {
                return syncDLObject;
            }
            if (event.equals("move")) {
                this.moveSyncDLObjects(syncDLObject);
            } else if (event.equals("restore")) {
                this.restoreSyncDLObjects(syncDLObject);
            } else if (event.equals("trash")) {
                this.trashSyncDLObjects(syncDLObject);
            }
        } else if (event.equals("delete")) {
            try {
                this.syncDLFileVersionDiffLocalService.deleteSyncDLFileVersionDiffs(typePK);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return syncDLObject;
    }

    public void deleteSyncDLObjects(String version, String type) {
        this.syncDLObjectPersistence.removeByV_T(version, type);
    }

    public SyncDLObject fetchSyncDLObject(String type, long typePK) {
        return this.syncDLObjectPersistence.fetchByT_T(type, typePK);
    }

    public long getLatestModifiedTime() {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Projection projection = ProjectionFactoryUtil.max((String)"modifiedTime");
        dynamicQuery.setProjection(projection);
        List modifiedTimes = this.syncDLObjectPersistence.findWithDynamicQuery(dynamicQuery);
        if (modifiedTimes.isEmpty() || (Long)modifiedTimes.get(0) == 0L) {
            return System.currentTimeMillis();
        }
        return (Long)modifiedTimes.get(0);
    }

    public List<SyncDLObject> getSyncDLObjects(long repositoryId, long parentFolderId) {
        return this.syncDLObjectPersistence.findByR_P(repositoryId, parentFolderId);
    }

    public void moveSyncDLObjects(final SyncDLObject parentSyncDLObject) throws PortalException {
        final String searchTreePath = StringUtil.quote((String)String.valueOf(parentSyncDLObject.getTypePK()), (String)"/");
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.like((String)"treePath", (Object)StringUtil.quote((String)searchTreePath, (String)"%")));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<SyncDLObject>(){

            public void performAction(SyncDLObject syncDLObject) throws PortalException {
                syncDLObject.setUserId(parentSyncDLObject.getUserId());
                syncDLObject.setUserName(parentSyncDLObject.getUserName());
                syncDLObject.setModifiedTime(parentSyncDLObject.getModifiedTime());
                String treePath = syncDLObject.getTreePath();
                String oldParentTreePath = treePath.substring(0, treePath.indexOf(searchTreePath) + searchTreePath.length());
                treePath = StringUtil.replaceFirst((String)treePath, (String)oldParentTreePath, (String)parentSyncDLObject.getTreePath());
                syncDLObject.setTreePath(treePath);
                syncDLObject.setLastPermissionChangeDate(parentSyncDLObject.getLastPermissionChangeDate());
                SyncDLObjectLocalServiceImpl.this.syncDLObjectPersistence.update((BaseModel)syncDLObject);
            }
        });
        actionableDynamicQuery.performActions();
    }

    public void restoreSyncDLObjects(final SyncDLObject parentSyncDLObject) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"event", (Object)"trash"));
                String treePath = parentSyncDLObject.getTreePath();
                dynamicQuery.add(RestrictionsFactoryUtil.like((String)"treePath", (Object)(treePath + "%")));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<SyncDLObject>(){

            public void performAction(SyncDLObject syncDLObject) throws PortalException {
                DLFileEntry dlFileEntry;
                DLFolder dlFolder;
                String type = syncDLObject.getType();
                if (type.equals("folder") ? (dlFolder = SyncDLObjectLocalServiceImpl.this.dlFolderLocalService.getFolder(syncDLObject.getTypePK())).isInTrash() : (dlFileEntry = SyncDLObjectLocalServiceImpl.this.dlFileEntryLocalService.getDLFileEntry(syncDLObject.getTypePK())).isInTrash()) {
                    return;
                }
                syncDLObject.setUserId(parentSyncDLObject.getUserId());
                syncDLObject.setUserName(parentSyncDLObject.getUserName());
                syncDLObject.setModifiedTime(parentSyncDLObject.getModifiedTime());
                syncDLObject.setEvent("restore");
                if (!type.equals("folder")) {
                    syncDLObject.setLanTokenKey(SyncDLObjectLocalServiceImpl.this._syncHelper.getLanTokenKey(parentSyncDLObject.getModifiedTime(), syncDLObject.getTypePK(), false));
                }
                SyncDLObjectLocalServiceImpl.this.syncDLObjectPersistence.update((BaseModel)syncDLObject);
            }
        });
        actionableDynamicQuery.performActions();
    }

    public void trashSyncDLObjects(final SyncDLObject parentSyncDLObject) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                dynamicQuery.add(RestrictionsFactoryUtil.ne((String)"event", (Object)"trash"));
                String treePath = parentSyncDLObject.getTreePath();
                dynamicQuery.add(RestrictionsFactoryUtil.like((String)"treePath", (Object)(treePath + "%")));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<SyncDLObject>(){

            public void performAction(SyncDLObject syncDLObject) throws PortalException {
                syncDLObject.setUserId(parentSyncDLObject.getUserId());
                syncDLObject.setUserName(parentSyncDLObject.getUserName());
                syncDLObject.setEvent("trash");
                SyncDLObjectLocalServiceImpl.this.syncDLObjectPersistence.update((BaseModel)syncDLObject);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected boolean isDefaultRepository(long folderId) throws PortalException {
        if (folderId == 0L) {
            return true;
        }
        Folder folder = this.dlAppLocalService.getFolder(folderId);
        return folder.isDefaultRepository();
    }
}

