/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLObjectLocalService;
import com.liferay.sync.util.SyncHelper;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Deprecated
@Component(immediate=true, service={VerifyUtil.class})
public class VerifyUtil {
    private static final Log _log = LogFactoryUtil.getLog(VerifyUtil.class);
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    private long _dlFoldersAndFileEntriesCount;
    private long _dlFoldersAndFileEntriesTotalCount;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private SyncDLObjectLocalService _syncDLObjectLocalService;
    private long _syncDLObjectsCount;
    private long _syncDLObjectsTotalCount;
    @Reference
    private SyncHelper _syncHelper;

    public static void verify() throws Exception {
        VerifyUtil verifyUtil = new VerifyUtil();
        verifyUtil.doVerify();
    }

    public void doVerify() throws Exception {
        List groups = this._groupLocalService.getGroups(-1, -1);
        for (Group group : groups) {
            if (group.isStaged()) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Verifying group " + group.getGroupId()));
            }
            this.verifyDLFileEntriesAndFolders(group.getGroupId());
            this.verifySyncDLObjects(group.getGroupId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Verification completed");
        }
    }

    protected void logCount(long count, long totalCount, String name) {
        if (_log.isDebugEnabled() && count % 1000L == 0L) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Verified ", String.valueOf(count), "/", String.valueOf(totalCount), " ", name}));
        }
    }

    protected void verifyDLFileEntriesAndFolders(long groupId) throws Exception {
        this._dlFoldersAndFileEntriesCount = 0L;
        ActionableDynamicQuery dlFolderActionableDynamicQuery = this._dlFolderLocalService.getActionableDynamicQuery();
        dlFolderActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property hiddenProperty = PropertyFactoryUtil.forName((String)"hidden");
                dynamicQuery.add(hiddenProperty.eq((Object)false));
                Property mountPointProperty = PropertyFactoryUtil.forName((String)"mountPoint");
                dynamicQuery.add(mountPointProperty.eq((Object)false));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                int[] workflowConstants = new int[]{0, 8};
                dynamicQuery.add(statusProperty.in(workflowConstants));
            }
        });
        dlFolderActionableDynamicQuery.setGroupId(groupId);
        dlFolderActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFolder>(){

            public void performAction(DLFolder dlFolder) throws PortalException {
                VerifyUtil.this._dlFoldersAndFileEntriesCount++;
                VerifyUtil.this.logCount(VerifyUtil.this._dlFoldersAndFileEntriesCount, VerifyUtil.this._dlFoldersAndFileEntriesTotalCount, "DL folders and DL file entries");
                try {
                    if (dlFolder.getStatus() == 0) {
                        VerifyUtil.this._syncHelper.addSyncDLObject(VerifyUtil.this._syncHelper.toSyncDLObject(dlFolder, 0L, "", "add"), VerifyUtil.this._syncDLObjectLocalService);
                    } else {
                        VerifyUtil.this._syncHelper.addSyncDLObject(VerifyUtil.this._syncHelper.toSyncDLObject(dlFolder, 0L, "", "trash"), VerifyUtil.this._syncDLObjectLocalService);
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        });
        ActionableDynamicQuery dlFileEntryActionableDynamicQuery = this._dlFileEntryLocalService.getActionableDynamicQuery();
        dlFileEntryActionableDynamicQuery.setGroupId(groupId);
        dlFileEntryActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFileEntry>(){

            public void performAction(DLFileEntry dlFileEntry) throws PortalException {
                VerifyUtil.this._dlFoldersAndFileEntriesCount++;
                VerifyUtil.this.logCount(VerifyUtil.this._dlFoldersAndFileEntriesCount, VerifyUtil.this._dlFoldersAndFileEntriesTotalCount, "DL folders and DL file entries");
                if (dlFileEntry.getStatus() != 0 && !dlFileEntry.isInTrash()) {
                    return;
                }
                try {
                    SyncDLObject syncDLObject = VerifyUtil.this._syncDLObjectLocalService.fetchSyncDLObject("file", dlFileEntry.getFileEntryId());
                    if (syncDLObject != null) {
                        Date modifiedDate = dlFileEntry.getModifiedDate();
                        if (syncDLObject.getModifiedTime() >= modifiedDate.getTime()) {
                            return;
                        }
                    }
                    String event = null;
                    event = dlFileEntry.getStatus() == 0 ? "add" : "trash";
                    if (dlFileEntry.isCheckedOut()) {
                        SyncDLObject approvedFileEntrySyncDLObject = VerifyUtil.this._syncHelper.toSyncDLObject(dlFileEntry, event, !dlFileEntry.isInTrash(), true);
                        VerifyUtil.this._syncHelper.addSyncDLObject(approvedFileEntrySyncDLObject, VerifyUtil.this._syncDLObjectLocalService);
                    }
                    VerifyUtil.this._syncHelper.addSyncDLObject(VerifyUtil.this._syncHelper.toSyncDLObject(dlFileEntry, event, !dlFileEntry.isInTrash()), VerifyUtil.this._syncDLObjectLocalService);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        });
        this._dlFoldersAndFileEntriesTotalCount = dlFolderActionableDynamicQuery.performCount() + dlFileEntryActionableDynamicQuery.performCount();
        dlFolderActionableDynamicQuery.performActions();
        dlFileEntryActionableDynamicQuery.performActions();
        this.logCount(this._dlFoldersAndFileEntriesCount, this._dlFoldersAndFileEntriesTotalCount, "DL folders and DL file entries");
    }

    protected void verifySyncDLObjects(final long groupId) throws Exception {
        this._syncDLObjectsCount = 0L;
        ActionableDynamicQuery actionableDynamicQuery = this._syncDLObjectLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property eventProperty = PropertyFactoryUtil.forName((String)"event");
                dynamicQuery.add(eventProperty.ne((Object)"delete"));
                Property repositoryIdProperty = PropertyFactoryUtil.forName((String)"repositoryId");
                dynamicQuery.add(repositoryIdProperty.eq((Object)groupId));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<SyncDLObject>(){

            public void performAction(SyncDLObject syncDLObject) throws PortalException {
                DLFileEntry dlFileEntry;
                VerifyUtil.this._syncDLObjectsCount++;
                VerifyUtil.this.logCount(VerifyUtil.this._syncDLObjectsCount, VerifyUtil.this._syncDLObjectsTotalCount, "Sync DL objects");
                String type = syncDLObject.getType();
                if (type.equals("file")) {
                    DLFileEntry dlFileEntry2 = VerifyUtil.this._dlFileEntryLocalService.fetchDLFileEntry(syncDLObject.getTypePK());
                    if (dlFileEntry2 == null) {
                        syncDLObject.setModifiedTime(System.currentTimeMillis());
                        syncDLObject.setEvent("delete");
                        VerifyUtil.this._syncHelper.addSyncDLObject(syncDLObject, VerifyUtil.this._syncDLObjectLocalService);
                    }
                } else if (type.equals("folder")) {
                    DLFolder dlFolder = VerifyUtil.this._dlFolderLocalService.fetchDLFolder(syncDLObject.getTypePK());
                    if (dlFolder == null) {
                        syncDLObject.setEvent("delete");
                        syncDLObject.setModifiedTime(System.currentTimeMillis());
                        VerifyUtil.this._syncHelper.addSyncDLObject(syncDLObject, VerifyUtil.this._syncDLObjectLocalService);
                    }
                } else if (type.equals("privateWorkingCopy") && ((dlFileEntry = VerifyUtil.this._dlFileEntryLocalService.fetchDLFileEntry(syncDLObject.getTypePK())) == null || !VerifyUtil.this._dlFileEntryLocalService.isFileEntryCheckedOut(syncDLObject.getTypePK()))) {
                    VerifyUtil.this._syncDLObjectLocalService.deleteSyncDLObject(syncDLObject);
                }
            }
        });
        this._syncDLObjectsTotalCount = actionableDynamicQuery.performCount();
        actionableDynamicQuery.performActions();
        this.logCount(this._syncDLObjectsTotalCount, this._syncDLObjectsTotalCount, "Sync DL objects");
    }
}

