/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.sync.engine.model;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

import com.liferay.sync.engine.service.persistence.BasePersistenceImpl;

/**
 * @author Shinn Lok
 */
@DatabaseTable(daoClass = BasePersistenceImpl.class, tableName = "SyncProp")
public class SyncProp extends BaseModel {

	public static final String KEY_BUILD_NUMBER = "buildNumber";

	public static final String KEY_GLOBAL_MAX_DOWNLOAD_RATE =
		"globalMaxDownloadRate";

	public static final String KEY_GLOBAL_MAX_UPLOAD_RATE =
		"globalMaxUploadRate";

	public static final String KEY_LAN_ENABLED = "lanEnabled";

	public static final String KEY_SYNC_LAN_CLIENT_UUID = "syncLanClientUuid";

	public String getKey() {
		return key;
	}

	public String getValue() {
		return value;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@DatabaseField(id = true, useGetSet = true)
	protected String key;

	@DatabaseField(useGetSet = true, width = 16777216)
	protected String value;

}