/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLObjectService;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

@ProviderType
public class SyncDLObjectServiceUtil {
    private static ServiceTracker<SyncDLObjectService, SyncDLObjectService> _serviceTracker;

    public static SyncDLObject addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, String checksum, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().addFileEntry(repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, file, checksum, serviceContext);
    }

    public static SyncDLObject addFolder(long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().addFolder(repositoryId, parentFolderId, name, description, serviceContext);
    }

    public static SyncDLObject cancelCheckOut(long fileEntryId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().cancelCheckOut(fileEntryId);
    }

    public static SyncDLObject checkInFileEntry(long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().checkInFileEntry(fileEntryId, majorVersion, changeLog, serviceContext);
    }

    public static SyncDLObject checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().checkOutFileEntry(fileEntryId, serviceContext);
    }

    public static SyncDLObject checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
    }

    public static SyncDLObject copyFileEntry(long sourceFileEntryId, long repositoryId, long folderId, String sourceFileName, String title, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().copyFileEntry(sourceFileEntryId, repositoryId, folderId, sourceFileName, title, serviceContext);
    }

    public static List<SyncDLObject> getAllFolderSyncDLObjects(long repositoryId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getAllFolderSyncDLObjects(repositoryId);
    }

    public static SyncDLObject getFileEntrySyncDLObject(long repositoryId, long folderId, String title) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getFileEntrySyncDLObject(repositoryId, folderId, title);
    }

    public static List<SyncDLObject> getFileEntrySyncDLObjects(long repositoryId, long folderId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getFileEntrySyncDLObjects(repositoryId, folderId);
    }

    public static SyncDLObject getFolderSyncDLObject(long folderId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getFolderSyncDLObject(folderId);
    }

    public static SyncDLObject getFolderSyncDLObject(long repositoryId, long parentFolderId, String name) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getFolderSyncDLObject(repositoryId, parentFolderId, name);
    }

    public static List<SyncDLObject> getFolderSyncDLObjects(long repositoryId, long parentFolderId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getFolderSyncDLObjects(repositoryId, parentFolderId);
    }

    public static Group getGroup(long groupId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getGroup(groupId);
    }

    public static long getLatestModifiedTime() throws PortalException {
        return SyncDLObjectServiceUtil.getService().getLatestModifiedTime();
    }

    public static String getOSGiServiceIdentifier() {
        return SyncDLObjectServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static Object getSyncContext() throws PortalException {
        return SyncDLObjectServiceUtil.getService().getSyncContext();
    }

    public static String getSyncDLObjectUpdate(long repositoryId, long lastAccessTime, int max) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getSyncDLObjectUpdate(repositoryId, lastAccessTime, max);
    }

    public static String getSyncDLObjectUpdate(long repositoryId, long lastAccessTime, int max, boolean retrieveFromCache) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getSyncDLObjectUpdate(repositoryId, lastAccessTime, max, retrieveFromCache);
    }

    public static String getSyncDLObjectUpdate(long repositoryId, long parentFolderId, long lastAccessTime) throws PortalException {
        return SyncDLObjectServiceUtil.getService().getSyncDLObjectUpdate(repositoryId, parentFolderId, lastAccessTime);
    }

    public static List<Group> getUserSitesGroups() throws PortalException {
        return SyncDLObjectServiceUtil.getService().getUserSitesGroups();
    }

    public static SyncDLObject moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().moveFileEntry(fileEntryId, newFolderId, serviceContext);
    }

    public static SyncDLObject moveFileEntryToTrash(long fileEntryId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().moveFileEntryToTrash(fileEntryId);
    }

    public static SyncDLObject moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().moveFolder(folderId, parentFolderId, serviceContext);
    }

    public static SyncDLObject moveFolderToTrash(long folderId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().moveFolderToTrash(folderId);
    }

    public static SyncDLObject patchFileEntry(long fileEntryId, long sourceVersionId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File deltaFile, String checksum, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().patchFileEntry(fileEntryId, sourceVersionId, sourceFileName, mimeType, title, description, changeLog, majorVersion, deltaFile, checksum, serviceContext);
    }

    public static SyncDLObject restoreFileEntryFromTrash(long fileEntryId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().restoreFileEntryFromTrash(fileEntryId);
    }

    public static SyncDLObject restoreFolderFromTrash(long folderId) throws PortalException {
        return SyncDLObjectServiceUtil.getService().restoreFolderFromTrash(folderId);
    }

    public static Map<String, Object> updateFileEntries(File zipFile) throws PortalException {
        return SyncDLObjectServiceUtil.getService().updateFileEntries(zipFile);
    }

    public static SyncDLObject updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, String checksum, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, checksum, serviceContext);
    }

    public static SyncDLObject updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return SyncDLObjectServiceUtil.getService().updateFolder(folderId, name, description, serviceContext);
    }

    public static SyncDLObjectService getService() {
        return (SyncDLObjectService)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(SyncDLObjectService.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), SyncDLObjectService.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

