/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.web.internal.util;

import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.template.MailTemplate;
import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.mail.kernel.template.MailTemplateContextBuilder;
import com.liferay.mail.kernel.template.MailTemplateFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.subscription.web.internal.configuration.SubscriptionConfiguration;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;

public class UnsubscribeHooks {
    private final SubscriptionConfiguration _configuration;
    private final SubscriptionSender _subscriptionSender;
    private final TicketLocalService _ticketLocalService;
    private final UserLocalService _userLocalService;
    private final Map<Long, Ticket> _userTicketMap = new HashMap<Long, Ticket>();

    public UnsubscribeHooks(SubscriptionConfiguration configuration, TicketLocalService ticketLocalService, UserLocalService userLocalService, SubscriptionSender subscriptionSender) {
        this._configuration = configuration;
        this._ticketLocalService = ticketLocalService;
        this._userLocalService = userLocalService;
        this._subscriptionSender = subscriptionSender;
    }

    public void addUnsubscriptionLinks(MailMessage mailMessage) {
        if (this._subscriptionSender.isBulk()) {
            return;
        }
        InternetAddress[] toAddresses = mailMessage.getTo();
        if (toAddresses.length > 0) {
            InternetAddress toAddress = toAddresses[0];
            User user = this._userLocalService.fetchUserByEmailAddress(this._subscriptionSender.getCompanyId(), toAddress.getAddress());
            if (user == null) {
                return;
            }
            Ticket ticket = this._userTicketMap.get(user.getUserId());
            if (ticket != null) {
                try {
                    String unsubscribeURL = this._getUnsubscribeURL(user, ticket);
                    this._addUnsubscribeHeader(mailMessage, unsubscribeURL);
                    this._addUnsubscribeLink(mailMessage, unsubscribeURL);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                finally {
                    this._userTicketMap.remove(user.getUserId());
                }
            }
        }
    }

    public void createUnsubscriptionTicket(Subscription subscription) {
        if (this._subscriptionSender.isBulk()) {
            return;
        }
        this._userTicketMap.put(subscription.getUserId(), this._getTicket(subscription));
    }

    private void _addUnsubscribeHeader(MailMessage mailMessage, String unsubscribeURL) {
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("List-Unsubscribe", "<" + unsubscribeURL + ">");
        mailMessage.setInternetHeaders(internetHeaders);
    }

    private void _addUnsubscribeLink(MailMessage mailMessage, String unsubscribeURL) throws IOException {
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        mailTemplateContextBuilder.put("[$UNSUBSCRIBE_URL$]", unsubscribeURL);
        MailTemplateContext mailTemplateContext = mailTemplateContextBuilder.build();
        MailTemplate bodyMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)mailMessage.getBody(), (boolean)true);
        String processedBody = bodyMailTemplate.renderAsString(LocaleUtil.US, mailTemplateContext);
        mailMessage.setBody(processedBody);
    }

    private Ticket _getTicket(Subscription subscription) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, this._configuration.unsubscriptionTicketExpirationTime());
        List tickets = this._ticketLocalService.getTickets(subscription.getCompanyId(), com.liferay.subscription.model.Subscription.class.getName(), subscription.getSubscriptionId(), 0);
        if (ListUtil.isEmpty((List)tickets)) {
            return this._ticketLocalService.addTicket(subscription.getCompanyId(), com.liferay.subscription.model.Subscription.class.getName(), subscription.getSubscriptionId(), 0, "", calendar.getTime(), this._subscriptionSender.getServiceContext());
        }
        try {
            Ticket ticket = (Ticket)tickets.get(0);
            return this._ticketLocalService.updateTicket(ticket.getTicketId(), com.liferay.subscription.model.Subscription.class.getName(), subscription.getSubscriptionId(), 0, "", calendar.getTime());
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    private String _getUnsubscribeURL(User user, Ticket ticket) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._subscriptionSender.getContextAttribute("[$PORTAL_URL$]"));
        sb.append(PortalUtil.getPathMain());
        sb.append("/portal/unsubscribe?key=");
        sb.append(ticket.getKey());
        sb.append("&userId=");
        sb.append(user.getUserId());
        return sb.toString();
    }
}

