/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchTicketException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.subscription.exception.NoSuchSubscriptionException;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_subscription_web_internal_portlet_UnsubscribePortlet", "mvc.command.name=/subscription/unsubscribe"}, service={MVCActionCommand.class})
public class UnsubscribeMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(UnsubscribeMVCActionCommand.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TicketLocalService _ticketLocalService;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String key = ParamUtil.getString((PortletRequest)actionRequest, (String)"key");
        long userId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userId");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_subscription_web_internal_portlet_UnsubscribePortlet", (String)"RENDER_PHASE");
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setParameter("mvcPath", "/unsubscribe/unsubscribed.jsp");
        portletURL.setParameter("key", key);
        portletURL.setParameter("userId", String.valueOf(userId));
        try {
            this._checkUser(userId, actionRequest);
            Subscription subscription = this._unsubscribe(key, userId);
            portletURL.setParameter("subscriptionTitle", this._getTitle(actionRequest.getLocale(), subscription));
            actionResponse.sendRedirect(portletURL.toString());
        }
        catch (NoSuchSubscriptionException nsse) {
            _log.error((Object)nsse, (Throwable)nsse);
            actionResponse.sendRedirect(portletURL.toString());
        }
        catch (PortalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass(), (Object)((Object)pe));
            actionResponse.setRenderParameter("mvcPath", "/unsubscribe/error.jsp");
        }
    }

    private void _checkUser(long userId, ActionRequest actionRequest) throws PortalException {
        User user = this._portal.getUser((PortletRequest)actionRequest);
        if (user != null && userId != user.getUserId()) {
            throw new PrincipalException();
        }
    }

    private void _checkUser(long userId, Subscription subscription) throws PrincipalException {
        if (subscription != null && subscription.getUserId() != userId) {
            throw new PrincipalException();
        }
    }

    private Ticket _getTicket(String key) throws PortalException {
        Ticket ticket = this._ticketLocalService.getTicket(key);
        if (ticket.getType() != 0) {
            throw new NoSuchTicketException("Invalid type " + ticket.getType());
        }
        String className = ticket.getClassName();
        if (!className.equals(Subscription.class.getName())) {
            throw new NoSuchTicketException("Invalid className " + className);
        }
        return ticket;
    }

    private String _getTitle(Locale locale, Subscription subscription) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(subscription.getClassPK());
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ((Object)((Object)this)).getClass());
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"blog-at-x", (Object)group.getDescriptiveName(locale));
    }

    private Subscription _unsubscribe(String key, long userId) throws PortalException {
        Ticket ticket = this._getTicket(key);
        long subscriptionId = ticket.getClassPK();
        if (ticket.isExpired()) {
            this._ticketLocalService.deleteTicket(ticket);
            throw new NoSuchTicketException("{ticketKey=" + key + "}");
        }
        Subscription subscription = this._subscriptionLocalService.getSubscription(subscriptionId);
        this._checkUser(userId, subscription);
        this._subscriptionLocalService.deleteSubscription(subscription);
        return subscription;
    }
}

