/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.model.impl;

import com.liferay.document.library.util.DLURLHelperUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.style.book.model.impl.StyleBookEntryBaseImpl;

public class StyleBookEntryImpl
extends StyleBookEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(StyleBookEntryImpl.class);

    public String getImagePreviewURL(ThemeDisplay themeDisplay) {
        if (this.getPreviewFileEntryId() <= 0L) {
            return "";
        }
        try {
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)this.getPreviewFileEntryId());
            if (fileEntry == null) {
                return "";
            }
            return DLURLHelperUtil.getImagePreviewURL((FileEntry)fileEntry, (ThemeDisplay)themeDisplay);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get image preview URL", (Throwable)exception);
            return "";
        }
    }

    public void populateZipWriter(ZipWriter zipWriter, String path) throws Exception {
        path = path + "/" + this.getStyleBookEntryKey();
        JSONObject jsonObject = JSONUtil.put((String)"frontendTokensValuesPath", (Object)"frontend-tokens-values.json").put("name", this.getName());
        FileEntry previewFileEntry = this._getPreviewFileEntry();
        if (previewFileEntry != null) {
            jsonObject.put("thumbnailPath", "thumbnail." + previewFileEntry.getExtension());
        }
        zipWriter.addEntry(path + "/style-book.json", jsonObject.toString());
        zipWriter.addEntry(path + "/frontend-tokens-values.json", this.getFrontendTokensValues());
        if (previewFileEntry != null) {
            zipWriter.addEntry(path + "/thumbnail." + previewFileEntry.getExtension(), previewFileEntry.getContentStream());
        }
    }

    private FileEntry _getPreviewFileEntry() {
        if (this.getPreviewFileEntryId() <= 0L) {
            return null;
        }
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)this.getPreviewFileEntryId());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get file entry preview ", (Throwable)portalException);
            }
            return null;
        }
    }
}

