/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class StylebookEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<StyleBookEntry> {
    public static final String[] CLASS_NAMES = new String[]{StyleBookEntry.class.getName()};
    @Reference(target="(model.class.name=com.liferay.style.book.model.StyleBookEntry)", unbind="-")
    private StagedModelRepository<StyleBookEntry> _stagedModelRepository;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public void deleteStagedModel(StyleBookEntry styleBookEntry) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)styleBookEntry);
    }

    public List<StyleBookEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, StyleBookEntry styleBookEntry) throws Exception {
        if (styleBookEntry.getPreviewFileEntryId() > 0L) {
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)styleBookEntry.getPreviewFileEntryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)styleBookEntry, (StagedModel)fileEntry, (String)"weak");
        }
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)styleBookEntry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)styleBookEntry), (ClassedModel)styleBookEntry);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long styleBookEntryId) throws Exception {
        StyleBookEntry existingStyleBookEntry = (StyleBookEntry)this.fetchMissingReference(uuid, groupId);
        if (existingStyleBookEntry == null) {
            return;
        }
        Map styleBookEntryIds = portletDataContext.getNewPrimaryKeysMap(StyleBookEntry.class);
        styleBookEntryIds.put(styleBookEntryId, existingStyleBookEntry.getStyleBookEntryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, StyleBookEntry styleBookEntry) throws Exception {
        StyleBookEntry importedStyleBookEntry = (StyleBookEntry)styleBookEntry.clone();
        importedStyleBookEntry.setGroupId(portletDataContext.getScopeGroupId());
        StyleBookEntry existingStyleBookEntry = (StyleBookEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(styleBookEntry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingStyleBookEntry == null || !portletDataContext.isDataStrategyMirror()) {
            importedStyleBookEntry = (StyleBookEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedStyleBookEntry);
        } else {
            importedStyleBookEntry.setMvccVersion(existingStyleBookEntry.getMvccVersion());
            importedStyleBookEntry.setStyleBookEntryId(existingStyleBookEntry.getStyleBookEntryId());
            importedStyleBookEntry = (StyleBookEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedStyleBookEntry);
        }
        if (styleBookEntry.getPreviewFileEntryId() > 0L) {
            Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
            long previewFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)styleBookEntry.getPreviewFileEntryId(), (long)0L);
            importedStyleBookEntry.setPreviewFileEntryId(previewFileEntryId);
            importedStyleBookEntry = this._styleBookEntryLocalService.updatePreviewFileEntryId(importedStyleBookEntry.getStyleBookEntryId(), previewFileEntryId);
        }
        portletDataContext.importClassedModel((ClassedModel)styleBookEntry, (ClassedModel)importedStyleBookEntry);
    }

    protected StagedModelRepository<StyleBookEntry> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

