/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.style.book.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalServiceUtil;

/**
 * The extended model base implementation for the StyleBookEntry service. Represents a row in the &quot;StyleBookEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link StyleBookEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see StyleBookEntryImpl
 * @see StyleBookEntry
 * @generated
 */
public abstract class StyleBookEntryBaseImpl
	extends StyleBookEntryModelImpl implements StyleBookEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a style book entry model instance should use the <code>StyleBookEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			StyleBookEntryLocalServiceUtil.addStyleBookEntry(this);
		}
		else {
			try {
				StyleBookEntryLocalServiceUtil.updateStyleBookEntry(this);
			}
			catch (PortalException portalException) {
				throw new SystemException(portalException);
			}
		}
	}

}