/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.base.StyleBookEntryServiceBaseImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=stylebook", "json.web.service.context.path=StyleBookEntry"}, service={AopService.class})
public class StyleBookEntryServiceImpl
extends StyleBookEntryServiceBaseImpl {
    @Reference(target="(resource.name=com.liferay.style.book)")
    private PortletResourcePermission _portletResourcePermission;

    public StyleBookEntry addStyleBookEntry(long groupId, String name, String styleBookEntryKey, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.addStyleBookEntry(this.getUserId(), groupId, name, styleBookEntryKey, serviceContext);
    }

    public StyleBookEntry addStyleBookEntry(long groupId, String frontendTokensValues, String name, String styleBookEntryKey, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.addStyleBookEntry(this.getUserId(), groupId, frontendTokensValues, name, styleBookEntryKey, serviceContext);
    }

    public StyleBookEntry copyStyleBookEntry(long groupId, long styleBookEntryId, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.copyStyleBookEntry(this.getUserId(), groupId, styleBookEntryId, serviceContext);
    }

    public StyleBookEntry deleteStyleBookEntry(long styleBookEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        return this.deleteStyleBookEntry(styleBookEntry);
    }

    public StyleBookEntry deleteStyleBookEntry(StyleBookEntry styleBookEntry) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.deleteStyleBookEntry(styleBookEntry);
    }

    public StyleBookEntry discardDraftStyleBookEntry(long styleBookEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.deleteDraft(styleBookEntry);
    }

    public StyleBookEntry publishDraft(long styleBookEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.publishDraft(styleBookEntry);
    }

    public StyleBookEntry updateDefaultStyleBookEntry(long styleBookEntryId, boolean defaultStyleBookEntry) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.updateDefaultStyleBookEntry(styleBookEntryId, defaultStyleBookEntry);
    }

    public StyleBookEntry updateFrontendTokensValues(long styleBookEntryId, String frontendTokensValues) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.updateFrontendTokensValues(styleBookEntryId, frontendTokensValues);
    }

    public StyleBookEntry updateName(long styleBookEntryId, String name) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.updateName(styleBookEntryId, name);
    }

    public StyleBookEntry updatePreviewFileEntryId(long styleBookEntryId, long previewFileEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.updatePreviewFileEntryId(styleBookEntryId, previewFileEntryId);
    }

    public StyleBookEntry updateStyleBookEntry(long styleBookEntryId, String frontendTokensValues, String name) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), styleBookEntry.getGroupId(), "MANAGE_STYLE_BOOK_ENTRIES");
        return this.styleBookEntryLocalService.updateStyleBookEntry(styleBookEntryId, frontendTokensValues, name);
    }
}

