/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.version.VersionModel;
import com.liferay.portal.kernel.model.version.VersionedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.version.VersionService;
import com.liferay.portal.kernel.service.version.VersionServiceListener;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.model.StyleBookEntryVersion;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import com.liferay.style.book.service.persistence.StyleBookEntryPersistence;
import com.liferay.style.book.service.persistence.StyleBookEntryVersionPersistence;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Reference;

public abstract class StyleBookEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
StyleBookEntryLocalService,
VersionService<StyleBookEntry, StyleBookEntryVersion> {
    private final Set<VersionServiceListener<StyleBookEntry, StyleBookEntryVersion>> _versionServiceListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected StyleBookEntryLocalService styleBookEntryLocalService;
    @Reference
    protected StyleBookEntryPersistence styleBookEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected StyleBookEntryVersionPersistence styleBookEntryVersionPersistence;

    @Indexable(type=IndexableType.REINDEX)
    public StyleBookEntry addStyleBookEntry(StyleBookEntry styleBookEntry) {
        styleBookEntry.setNew(true);
        return (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)styleBookEntry);
    }

    @Transactional(enabled=false)
    public StyleBookEntry create() {
        long primaryKey = this.counterLocalService.increment(StyleBookEntry.class.getName());
        StyleBookEntry draftStyleBookEntry = this.styleBookEntryPersistence.create(primaryKey);
        draftStyleBookEntry.setHeadId(primaryKey);
        return draftStyleBookEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public StyleBookEntry deleteStyleBookEntry(long styleBookEntryId) throws PortalException {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.fetchByPrimaryKey(styleBookEntryId);
        if (styleBookEntry != null) {
            this.delete(styleBookEntry);
        }
        return styleBookEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public StyleBookEntry deleteStyleBookEntry(StyleBookEntry styleBookEntry) throws PortalException {
        this.delete(styleBookEntry);
        return styleBookEntry;
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.styleBookEntryPersistence.dslQuery(dslQuery);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(StyleBookEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.styleBookEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.styleBookEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.styleBookEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.styleBookEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.styleBookEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public StyleBookEntry fetchStyleBookEntry(long styleBookEntryId) {
        return this.styleBookEntryPersistence.fetchByPrimaryKey(styleBookEntryId);
    }

    public StyleBookEntry getStyleBookEntry(long styleBookEntryId) throws PortalException {
        return this.styleBookEntryPersistence.findByPrimaryKey(styleBookEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.styleBookEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(StyleBookEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("styleBookEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.styleBookEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(StyleBookEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("styleBookEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.styleBookEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(StyleBookEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("styleBookEntryId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.styleBookEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.styleBookEntryLocalService.deleteStyleBookEntry((StyleBookEntry)persistedModel);
    }

    public BasePersistence<StyleBookEntry> getBasePersistence() {
        return this.styleBookEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.styleBookEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<StyleBookEntry> getStyleBookEntries(int start, int end) {
        return this.styleBookEntryPersistence.findAll(start, end);
    }

    public int getStyleBookEntriesCount() {
        return this.styleBookEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public StyleBookEntry updateStyleBookEntry(StyleBookEntry draftStyleBookEntry) throws PortalException {
        return this.updateDraft(draftStyleBookEntry);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{StyleBookEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.styleBookEntryLocalService = (StyleBookEntryLocalService)aopProxy;
    }

    @Indexable(type=IndexableType.REINDEX)
    public StyleBookEntry checkout(StyleBookEntry publishedStyleBookEntry, int version) throws PortalException {
        if (!publishedStyleBookEntry.isHead()) {
            throw new IllegalArgumentException("Unable to checkout with unpublished changes " + publishedStyleBookEntry.getHeadId());
        }
        StyleBookEntry draftStyleBookEntry = this.styleBookEntryPersistence.fetchByHeadId(publishedStyleBookEntry.getPrimaryKey());
        if (draftStyleBookEntry != null) {
            throw new IllegalArgumentException("Unable to checkout with unpublished changes " + publishedStyleBookEntry.getPrimaryKey());
        }
        StyleBookEntryVersion styleBookEntryVersion = this.getVersion(publishedStyleBookEntry, version);
        draftStyleBookEntry = this._createDraft(publishedStyleBookEntry);
        styleBookEntryVersion.populateVersionedModel((VersionedModel)draftStyleBookEntry);
        draftStyleBookEntry = (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)draftStyleBookEntry);
        for (VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterCheckout((VersionedModel)draftStyleBookEntry, version);
        }
        return draftStyleBookEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public StyleBookEntry delete(StyleBookEntry publishedStyleBookEntry) throws PortalException {
        if (!publishedStyleBookEntry.isHead()) {
            throw new IllegalArgumentException("StyleBookEntry is a draft " + publishedStyleBookEntry.getPrimaryKey());
        }
        StyleBookEntry draftStyleBookEntry = this.styleBookEntryPersistence.fetchByHeadId(publishedStyleBookEntry.getPrimaryKey());
        if (draftStyleBookEntry != null) {
            this.deleteDraft(draftStyleBookEntry);
        }
        for (StyleBookEntryVersion styleBookEntryVersion : this.getVersions(publishedStyleBookEntry)) {
            this.styleBookEntryVersionPersistence.remove((BaseModel)styleBookEntryVersion);
        }
        this.styleBookEntryPersistence.remove((BaseModel)publishedStyleBookEntry);
        for (VersionServiceListener versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDelete((VersionedModel)publishedStyleBookEntry);
        }
        return publishedStyleBookEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public StyleBookEntry deleteDraft(StyleBookEntry draftStyleBookEntry) throws PortalException {
        if (draftStyleBookEntry.isHead()) {
            throw new IllegalArgumentException("StyleBookEntry is not a draft " + draftStyleBookEntry.getPrimaryKey());
        }
        this.styleBookEntryPersistence.remove((BaseModel)draftStyleBookEntry);
        for (VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDeleteDraft((VersionedModel)draftStyleBookEntry);
        }
        return draftStyleBookEntry;
    }

    public StyleBookEntryVersion deleteVersion(StyleBookEntryVersion styleBookEntryVersion) throws PortalException {
        StyleBookEntryVersion latestStyleBookEntryVersion = this.styleBookEntryVersionPersistence.findByStyleBookEntryId_First(styleBookEntryVersion.getVersionedModelId(), null);
        if (latestStyleBookEntryVersion.getVersion() == styleBookEntryVersion.getVersion()) {
            throw new IllegalArgumentException("Unable to delete latest version " + styleBookEntryVersion.getVersion());
        }
        styleBookEntryVersion = (StyleBookEntryVersion)this.styleBookEntryVersionPersistence.remove((BaseModel)styleBookEntryVersion);
        for (VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDeleteVersion((VersionModel)styleBookEntryVersion);
        }
        return styleBookEntryVersion;
    }

    public StyleBookEntry fetchDraft(StyleBookEntry styleBookEntry) {
        if (styleBookEntry.isHead()) {
            return this.styleBookEntryPersistence.fetchByHeadId(styleBookEntry.getPrimaryKey());
        }
        return styleBookEntry;
    }

    public StyleBookEntry fetchDraft(long primaryKey) {
        return this.styleBookEntryPersistence.fetchByHeadId(primaryKey);
    }

    public StyleBookEntryVersion fetchLatestVersion(StyleBookEntry styleBookEntry) {
        long primaryKey = styleBookEntry.getHeadId();
        if (styleBookEntry.isHead()) {
            primaryKey = styleBookEntry.getPrimaryKey();
        }
        return this.styleBookEntryVersionPersistence.fetchByStyleBookEntryId_First(primaryKey, null);
    }

    public StyleBookEntry fetchPublished(StyleBookEntry styleBookEntry) {
        if (styleBookEntry.isHead()) {
            return styleBookEntry;
        }
        if (styleBookEntry.getHeadId() == styleBookEntry.getPrimaryKey()) {
            return null;
        }
        return this.styleBookEntryPersistence.fetchByPrimaryKey(styleBookEntry.getHeadId());
    }

    public StyleBookEntry fetchPublished(long primaryKey) {
        StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.fetchByPrimaryKey(primaryKey);
        if (styleBookEntry == null || styleBookEntry.getHeadId() == styleBookEntry.getPrimaryKey()) {
            return null;
        }
        return styleBookEntry;
    }

    public StyleBookEntry getDraft(StyleBookEntry styleBookEntry) throws PortalException {
        if (!styleBookEntry.isHead()) {
            return styleBookEntry;
        }
        StyleBookEntry draftStyleBookEntry = this.styleBookEntryPersistence.fetchByHeadId(styleBookEntry.getPrimaryKey());
        if (draftStyleBookEntry == null) {
            draftStyleBookEntry = this.styleBookEntryLocalService.updateDraft(this._createDraft(styleBookEntry));
        }
        return draftStyleBookEntry;
    }

    public StyleBookEntry getDraft(long primaryKey) throws PortalException {
        StyleBookEntry draftStyleBookEntry = this.styleBookEntryPersistence.fetchByHeadId(primaryKey);
        if (draftStyleBookEntry == null) {
            StyleBookEntry styleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(primaryKey);
            draftStyleBookEntry = this.styleBookEntryLocalService.updateDraft(this._createDraft(styleBookEntry));
        }
        return draftStyleBookEntry;
    }

    public StyleBookEntryVersion getVersion(StyleBookEntry styleBookEntry, int version) throws PortalException {
        long primaryKey = styleBookEntry.getHeadId();
        if (styleBookEntry.isHead()) {
            primaryKey = styleBookEntry.getPrimaryKey();
        }
        return this.styleBookEntryVersionPersistence.findByStyleBookEntryId_Version(primaryKey, version);
    }

    public List<StyleBookEntryVersion> getVersions(StyleBookEntry styleBookEntry) {
        long primaryKey = styleBookEntry.getPrimaryKey();
        if (!styleBookEntry.isHead()) {
            if (styleBookEntry.getHeadId() == styleBookEntry.getPrimaryKey()) {
                return Collections.emptyList();
            }
            primaryKey = styleBookEntry.getHeadId();
        }
        return this.styleBookEntryVersionPersistence.findByStyleBookEntryId(primaryKey);
    }

    @Indexable(type=IndexableType.REINDEX)
    public StyleBookEntry publishDraft(StyleBookEntry draftStyleBookEntry) throws PortalException {
        if (draftStyleBookEntry.isHead()) {
            throw new IllegalArgumentException("Can only publish drafts " + draftStyleBookEntry.getPrimaryKey());
        }
        StyleBookEntry headStyleBookEntry = null;
        int version = 1;
        if (draftStyleBookEntry.getHeadId() == draftStyleBookEntry.getPrimaryKey()) {
            headStyleBookEntry = this.create();
            draftStyleBookEntry.setHeadId(headStyleBookEntry.getPrimaryKey());
        } else {
            headStyleBookEntry = this.styleBookEntryPersistence.findByPrimaryKey(draftStyleBookEntry.getHeadId());
            StyleBookEntryVersion latestStyleBookEntryVersion = this.styleBookEntryVersionPersistence.findByStyleBookEntryId_First(draftStyleBookEntry.getHeadId(), null);
            version = latestStyleBookEntryVersion.getVersion() + 1;
        }
        StyleBookEntryVersion styleBookEntryVersion = this.styleBookEntryVersionPersistence.create(this.counterLocalService.increment(StyleBookEntryVersion.class.getName()));
        styleBookEntryVersion.setVersion(version);
        styleBookEntryVersion.setVersionedModelId(headStyleBookEntry.getPrimaryKey());
        draftStyleBookEntry.populateVersionModel((VersionModel)styleBookEntryVersion);
        this.styleBookEntryVersionPersistence.update((BaseModel)styleBookEntryVersion);
        styleBookEntryVersion.populateVersionedModel((VersionedModel)headStyleBookEntry);
        headStyleBookEntry.setHeadId(-headStyleBookEntry.getPrimaryKey());
        headStyleBookEntry = (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)headStyleBookEntry);
        for (VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterPublishDraft((VersionedModel)draftStyleBookEntry, version);
        }
        this.deleteDraft(draftStyleBookEntry);
        return headStyleBookEntry;
    }

    public void registerListener(VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener) {
        this._versionServiceListeners.add(versionServiceListener);
    }

    public void unregisterListener(VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener) {
        this._versionServiceListeners.remove(versionServiceListener);
    }

    @Indexable(type=IndexableType.REINDEX)
    public StyleBookEntry updateDraft(StyleBookEntry draftStyleBookEntry) throws PortalException {
        if (draftStyleBookEntry.isHead()) {
            throw new IllegalArgumentException("Can only update draft entries " + draftStyleBookEntry.getPrimaryKey());
        }
        StyleBookEntry previousStyleBookEntry = this.styleBookEntryPersistence.fetchByPrimaryKey(draftStyleBookEntry.getPrimaryKey());
        draftStyleBookEntry = (StyleBookEntry)this.styleBookEntryPersistence.update((BaseModel)draftStyleBookEntry);
        if (previousStyleBookEntry == null) {
            for (VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener : this._versionServiceListeners) {
                versionServiceListener.afterCreateDraft((VersionedModel)draftStyleBookEntry);
            }
        } else {
            for (VersionServiceListener<StyleBookEntry, StyleBookEntryVersion> versionServiceListener : this._versionServiceListeners) {
                versionServiceListener.afterUpdateDraft((VersionedModel)draftStyleBookEntry);
            }
        }
        return draftStyleBookEntry;
    }

    private StyleBookEntry _createDraft(StyleBookEntry publishedStyleBookEntry) throws PortalException {
        StyleBookEntry draftStyleBookEntry = this.create();
        draftStyleBookEntry.setHeadId(publishedStyleBookEntry.getPrimaryKey());
        draftStyleBookEntry.setGroupId(publishedStyleBookEntry.getGroupId());
        draftStyleBookEntry.setCompanyId(publishedStyleBookEntry.getCompanyId());
        draftStyleBookEntry.setUserId(publishedStyleBookEntry.getUserId());
        draftStyleBookEntry.setUserName(publishedStyleBookEntry.getUserName());
        draftStyleBookEntry.setCreateDate(publishedStyleBookEntry.getCreateDate());
        draftStyleBookEntry.setDefaultStyleBookEntry(publishedStyleBookEntry.getDefaultStyleBookEntry());
        draftStyleBookEntry.setFrontendTokensValues(publishedStyleBookEntry.getFrontendTokensValues());
        draftStyleBookEntry.setName(publishedStyleBookEntry.getName());
        draftStyleBookEntry.setPreviewFileEntryId(publishedStyleBookEntry.getPreviewFileEntryId());
        draftStyleBookEntry.setStyleBookEntryKey(publishedStyleBookEntry.getStyleBookEntryKey());
        draftStyleBookEntry.resetOriginalValues();
        return draftStyleBookEntry;
    }

    public String getOSGiServiceIdentifier() {
        return StyleBookEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return StyleBookEntry.class;
    }

    protected String getModelClassName() {
        return StyleBookEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.styleBookEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

