/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.util;

import com.liferay.apio.architect.functional.Try;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentLocationForm;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentValuesForm;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component(service={JournalArticleContentHelper.class})
public class JournalArticleContentHelper {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private JournalArticleService _journalArticleService;

    public String createJournalArticleContent(List<StructuredContentValuesForm> structuredContentValuesForms, DDMStructure ddmStructure, Locale locale) {
        return (String)Try.fromFallible(() -> {
            String localeId = LocaleUtil.toLanguageId((Locale)locale);
            Document document = this._getDocument();
            Element rootElement = this._getRootElement(localeId, document);
            document.appendChild(rootElement);
            DDMForm ddmForm = ddmStructure.getDDMForm();
            for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
                String name = ddmFormField.getName();
                String type = this._getType(ddmFormField);
                Element dynamicElement = this._getDynamicElement(document, name, type);
                Optional<StructuredContentValuesForm> structuredContentValuesFormOptional = this._findStructuredContentValuesFormOptional(structuredContentValuesForms, name);
                Element contentElement = this._getContentElement(document, localeId, structuredContentValuesFormOptional, type);
                dynamicElement.appendChild(contentElement);
                rootElement.appendChild(dynamicElement);
            }
            return this._toString(document);
        }).orElse((Object)"");
    }

    private Optional<StructuredContentValuesForm> _findStructuredContentValuesFormOptional(List<StructuredContentValuesForm> structuredContentValuesForms, String name) {
        Stream stream = structuredContentValuesForms.stream();
        return stream.filter(value -> name.equals(value.getName())).findFirst();
    }

    private Element _getContentElement(Document document, String localeId, Optional<StructuredContentValuesForm> structuredContentValuesFormOptional, String type) {
        Element element = document.createElement("dynamic-content");
        element.setAttribute("language-id", localeId);
        return structuredContentValuesFormOptional.map(structuredContentValuesForm -> {
            if (type.equals("list") && this._isJsonArray(structuredContentValuesForm.getValue())) {
                return this._getDynamicContentListElement(document, element, (StructuredContentValuesForm)structuredContentValuesForm);
            }
            String data = this._getData((StructuredContentValuesForm)structuredContentValuesForm, type);
            element.appendChild(document.createCDATASection(data));
            return element;
        }).orElse(element);
    }

    private String _getData(StructuredContentValuesForm structuredContentValuesForm, String type) {
        if (type.equals("image") || type.equals("document-library")) {
            return this._getFileData(structuredContentValuesForm, type);
        }
        if (type.equals("ddm-geolocation")) {
            return this._getGeoLocationData(structuredContentValuesForm);
        }
        if (type.equals("ddm-journal-article")) {
            return this._getStructuredContentData(structuredContentValuesForm);
        }
        return structuredContentValuesForm.getValue();
    }

    private Document _getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    private String _getDocumentType(String type) {
        if (type.equals("document-library")) {
            return "document";
        }
        return "journal";
    }

    private Element _getDynamicContentListElement(Document document, Element element, StructuredContentValuesForm structuredContentValuesForm) {
        return (Element)Try.fromFallible(structuredContentValuesForm::getValue).map(JSONFactoryUtil::createJSONArray).map(jsonArray -> {
            for (int i = 0; i < jsonArray.length(); ++i) {
                Element optionElement = document.createElement("option");
                String value = jsonArray.getString(i);
                optionElement.appendChild(document.createCDATASection(value));
                element.appendChild(optionElement);
            }
            return element;
        }).orElse((Object)element);
    }

    private Element _getDynamicElement(Document document, String name, String type) {
        Element element = document.createElement("dynamic-element");
        element.setAttribute("index-type", "keyword");
        element.setAttribute("name", name);
        element.setAttribute("type", type);
        return element;
    }

    private String _getFileData(StructuredContentValuesForm structuredContentValuesForm, String type) {
        return (String)Try.fromFallible(structuredContentValuesForm::getDocument).map(arg_0 -> ((DLAppService)this._dlAppService).getFileEntry(arg_0)).map(fileEntry -> {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("alt", structuredContentValuesForm.getValue());
            jsonObject.put("fileEntryId", fileEntry.getFileEntryId());
            jsonObject.put("groupId", fileEntry.getGroupId());
            jsonObject.put("name", fileEntry.getFileName());
            jsonObject.put("resourcePrimKey", fileEntry.getPrimaryKey());
            jsonObject.put("title", fileEntry.getFileName());
            jsonObject.put("type", this._getDocumentType(type));
            jsonObject.put("uuid", fileEntry.getUuid());
            return jsonObject.toString();
        }).orElse(null);
    }

    private String _getGeoLocationData(StructuredContentValuesForm structuredContentValuesForm) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        StructuredContentLocationForm structuredContentLocationForm = structuredContentValuesForm.getStructuredContentLocationForm();
        jsonObject.put("latitude", (Object)structuredContentLocationForm.getLatitude());
        jsonObject.put("longitude", (Object)structuredContentLocationForm.getLongitude());
        return jsonObject.toString();
    }

    private Element _getRootElement(String localeId, Document document) {
        Element element = document.createElement("root");
        element.setAttribute("available-locales", localeId);
        element.setAttribute("default-locale", localeId);
        return element;
    }

    private String _getStructuredContentData(StructuredContentValuesForm structuredContentValuesForm) {
        return (String)Try.fromFallible(structuredContentValuesForm::getStructuredContent).map(arg_0 -> ((JournalArticleService)this._journalArticleService).getArticle(arg_0)).map(journalArticle -> {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("className", JournalArticle.class.getName());
            jsonObject.put("classPK", journalArticle.getResourcePrimKey());
            jsonObject.put("title", journalArticle.getTitle());
            return jsonObject.toString();
        }).orElse(null);
    }

    private String _getType(DDMFormField ddmFormField) {
        String type = ddmFormField.getType();
        if (type.equals("ddm-image") || type.equals("ddm-documentlibrary") || type.equals("checkbox")) {
            return ddmFormField.getDataType();
        }
        if (type.equals("ddm-text-html")) {
            return "text_area";
        }
        if (type.equals("select")) {
            return "list";
        }
        return type;
    }

    private boolean _isJsonArray(String value) {
        return Try.fromFallible(() -> JSONFactoryUtil.createJSONArray((String)value)).isSuccess();
    }

    private String _toString(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }
}

