/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.architect.resource;

import com.liferay.aggregate.rating.apio.architect.identifier.AggregateRatingIdentifier;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.model.DDMFormValuesReader;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.comment.apio.architect.identifier.CommentIdentifier;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleModel;
import com.liferay.journal.model.JournalArticleWrapper;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalHelper;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.structure.apio.architect.identifier.ContentStructureIdentifier;
import com.liferay.structure.apio.architect.util.StructureFieldConverter;
import com.liferay.structured.content.apio.architect.identifier.StructuredContentIdentifier;
import com.liferay.structured.content.apio.architect.resource.StructuredContentField;
import com.liferay.structured.content.apio.architect.util.StructuredContentUtil;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentCreatorForm;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentUpdaterForm;
import com.liferay.structured.content.apio.internal.model.RenderedJournalArticle;
import com.liferay.structured.content.apio.internal.util.JournalArticleContentHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NestedCollectionResource.class})
public class StructuredContentNestedCollectionResource
implements NestedCollectionResource<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long, StructuredContentIdentifier, Long, ContentSpaceIdentifier> {
    public static final String VALUES_NAME = "values";
    private static final Log _log = LogFactoryUtil.getLog(StructuredContentNestedCollectionResource.class);
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DLAppService _dlAppService;
    private volatile EntityModel _entityModel;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> _expressionConvert;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private JournalArticleContentHelper _journalArticleContentHelper;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalHelper _journalHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SearchResultPermissionFilterFactory _searchResultPermissionFilterFactory;
    @Reference
    private StructureFieldConverter _structureFieldConverter;

    public static String encodeFilterAndSortIdentifier(DDMStructure ddmStructure, String name) {
        return StringBundler.concat((Object[])new Object[]{"_", ddmStructure.getStructureId(), "_", name});
    }

    public NestedCollectionRoutes<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, AcceptLanguage.class, ThemeDisplay.class, Filter.class, com.liferay.portal.odata.sort.Sort.class).addCreator(this::_addJournalArticle, AcceptLanguage.class, ThemeDisplay.class, this._hasPermission.forAddingIn(ContentSpaceIdentifier.class), StructuredContentCreatorForm::buildForm).build();
    }

    public String getName() {
        return "structured-contents";
    }

    public ItemRoutes<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long> itemRoutes(ItemRoutes.Builder<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long> builder) {
        return builder.addGetter(this::_getJournalArticleWrapper, AcceptLanguage.class, ThemeDisplay.class).addRemover(Idempotent.idempotent(this::_deleteJournalArticle), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).addUpdater(this::_updateJournalArticle, AcceptLanguage.class, ThemeDisplay.class, (arg_0, arg_1) -> this._hasPermission.forUpdating(arg_0, arg_1), StructuredContentUpdaterForm::buildForm).build();
    }

    public Representor<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper> representor(Representor.Builder<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("StructuredContent", new String[0]).identifier(JournalArticleModel::getResourcePrimKey).addBidirectionalModel("contentSpace", "structuredContents", ContentSpaceIdentifier.class, JournalArticleModel::getGroupId).addDate("dateCreated", JournalArticleModel::getCreateDate)).addDate("dateModified", JournalArticleModel::getModifiedDate)).addDate("datePublished", JournalArticleModel::getDisplayDate)).addDate("lastReviewed", JournalArticleModel::getReviewDate)).addLinkedModel("aggregateRating", AggregateRatingIdentifier.class, this::_createClassNameClassPK)).addLinkedModel("contentStructure", ContentStructureIdentifier.class, this::_getJournalArticleStructureId)).addLinkedModel("creator", PersonIdentifier.class, JournalArticleModel::getUserId)).addLocalizedStringByLocale("description", JournalArticleWrapper::getDescription)).addLocalizedStringByLocale("title", JournalArticle::getTitle)).addNestedList("renderedContentsByTemplate", this::_getRenderedJournalArticles, nestedBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)nestedBuilder.types("templates", new String[0]).addLocalizedStringByLocale("template", RenderedJournalArticle::getTemplateName)).addLocalizedStringByLocale("renderedContent", RenderedJournalArticle::getRenderedContent)).build())).addNestedList(VALUES_NAME, this::_getStructuredContentFields, fieldValuesBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)fieldValuesBuilder.types("ContentFieldValue", new String[0]).addLinkedModel("document", MediaObjectIdentifier.class, structuredContentField -> (Long)Try.fromFallible(() -> structuredContentField.getLocalizedValue(LocaleUtil.getDefault())).map(value -> StructuredContentUtil.getFileEntryId((String)value, (DLAppService)this._dlAppService)).orElse(null))).addLinkedModel("structuredContent", StructuredContentIdentifier.class, this::_getStructuredContentId)).addLocalizedStringByLocale("label", StructuredContentField::getLocalizedLabel)).addLocalizedStringByLocale("value", StructuredContentField::getLocalizedValue)).addNested("geo", this::_getGeoJSONObject, geoBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)geoBuilder.types("GeoCoordinates", new String[0]).addNumber("latitude", jsonObject -> jsonObject.getDouble("latitude"))).addNumber("longitude", jsonObject -> jsonObject.getDouble("longitude"))).build())).addRelativeURL("link", this::_getLink)).addString("dataType", StructuredContentField::getDataType)).addString("filterAndSortIdentifier", StructuredContentField::getFilterAndSortIdentifier)).addString("inputControl", StructuredContentField::getInputControl)).addString("name", StructuredContentField::getName)).build())).addRelatedCollection("category", CategoryIdentifier.class).addRelatedCollection("comment", CommentIdentifier.class).addStringList("availableLanguages", journalArticle -> Arrays.asList(LocaleUtil.toW3cLanguageIds((String[])journalArticle.getAvailableLanguageIds())))).addStringList("keywords", this::_getJournalArticleAssetTags)).build();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=StructuredContent)", unbind="unbind")
    protected void setEntityModel(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + entityModel));
        }
        this._entityModel = entityModel;
    }

    protected void unbind(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + entityModel));
        }
        this._entityModel = null;
    }

    private com.liferay.structured.content.apio.internal.model.JournalArticleWrapper _addJournalArticle(long contentSpaceId, StructuredContentCreatorForm structuredContentCreatorForm, AcceptLanguage acceptLanguage, ThemeDisplay themeDisplay) throws PortalException {
        Long ddmStructureId = structuredContentCreatorForm.getContentStructureId();
        DDMStructure ddmStructure = this._ddmStructureService.getStructure(ddmStructureId.longValue());
        Locale locale = this._getLocale(acceptLanguage, contentSpaceId);
        String content = this._journalArticleContentHelper.createJournalArticleContent(structuredContentCreatorForm.getStructuredContentValuesForms(), ddmStructure, locale);
        String ddmStructureKey = ddmStructure.getStructureKey();
        String ddmTemplateKey = this._getDDMTemplateKey(ddmStructure);
        Calendar calendar = Calendar.getInstance();
        ServiceContext serviceContext = structuredContentCreatorForm.getServiceContext(contentSpaceId);
        JournalArticle journalArticle = this._journalArticleService.addArticle(contentSpaceId, 0L, 0L, 0L, null, true, structuredContentCreatorForm.getTitleMap(locale), structuredContentCreatorForm.getDescriptionMap(locale), content, ddmStructureKey, ddmTemplateKey, null, this._getDefaultValue(structuredContentCreatorForm.getPublishedDateMonthOptional(), calendar.get(2)).intValue(), this._getDefaultValue(structuredContentCreatorForm.getPublishedDateDayOptional(), calendar.get(5)).intValue(), this._getDefaultValue(structuredContentCreatorForm.getPublishedDateYearOptional(), calendar.get(1)).intValue(), this._getDefaultValue(structuredContentCreatorForm.getPublishedDateHourOptional(), calendar.get(10)).intValue(), this._getDefaultValue(structuredContentCreatorForm.getPublishedDateMinuteOptional(), calendar.get(12)).intValue(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, null, serviceContext);
        return new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper(journalArticle, locale, themeDisplay);
    }

    private ClassNameClassPK _createClassNameClassPK(JournalArticle journalArticle) {
        return ClassNameClassPK.create((String)JournalArticle.class.getName(), (long)journalArticle.getResourcePrimKey());
    }

    private SearchContext _createSearchContext(long companyId, long groupId, Locale locale, com.liferay.portal.odata.sort.Sort sort, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(0L));
        searchContext.setAttribute("head", (Serializable)Boolean.TRUE);
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        List<Sort> sorts = this._getSorts(sort.getSortFields(), locale);
        if (!sorts.isEmpty()) {
            searchContext.setSorts(sorts.toArray(new Sort[0]));
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        queryConfig.setSelectedFieldNames(new String[]{"articleId", "scopeGroupId"});
        return searchContext;
    }

    private void _deleteJournalArticle(long journalArticleId) throws PortalException {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(journalArticleId);
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getArticleResourceUuid(), new ServiceContext());
    }

    private String _getDDMTemplateKey(DDMStructure ddmStructure) {
        List ddmTemplates = ddmStructure.getTemplates();
        DDMTemplate ddmTemplate = (DDMTemplate)ddmTemplates.get(0);
        return ddmTemplate.getTemplateKey();
    }

    private <T> T _getDefaultValue(Optional<T> optional, T defaultValue) {
        return optional.orElse(defaultValue);
    }

    private Query _getFullQuery(Filter filter, Locale locale, SearchContext searchContext) throws SearchException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(JournalArticle.class);
        BooleanQuery booleanQuery = indexer.getFullQuery(searchContext);
        com.liferay.portal.kernel.search.filter.Filter searchFilter = this._getSearchFilter(filter, locale);
        if (searchFilter != null) {
            BooleanFilter preBooleanFilter = booleanQuery.getPreBooleanFilter();
            preBooleanFilter.add(searchFilter, BooleanClauseOccur.MUST);
        }
        return booleanQuery;
    }

    private JSONObject _getGeoJSONObject(StructuredContentField structuredContentField) {
        return (JSONObject)Try.fromFallible(() -> structuredContentField.getLocalizedValue(LocaleUtil.getDefault())).filter(StructuredContentUtil::isJSONObject).filter(string -> string.contains("latitude")).map(JSONFactoryUtil::createJSONObject).orElse(null);
    }

    private JournalArticle _getJournalArticle(JSONObject jsonObject) throws PortalException {
        long classPK = jsonObject.getLong("classPK");
        return this._journalArticleService.getLatestArticle(classPK);
    }

    private List<String> _getJournalArticleAssetTags(JournalArticle journalArticle) {
        List assetTags = this._assetTagLocalService.getTags(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        return ListUtil.toList((List)assetTags, AssetTagModel::getName);
    }

    private Long _getJournalArticleStructureId(com.liferay.structured.content.apio.internal.model.JournalArticleWrapper journalArticleWrapper) {
        DDMStructure ddmStructure = journalArticleWrapper.getDDMStructure();
        return ddmStructure.getStructureId();
    }

    private com.liferay.structured.content.apio.internal.model.JournalArticleWrapper _getJournalArticleWrapper(long journalArticleId, AcceptLanguage acceptLanguage, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(journalArticleId);
        return new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper(journalArticle, acceptLanguage.getPreferredLocale(), themeDisplay);
    }

    private String _getLayoutLink(JSONObject jsonObject) throws PortalException {
        long groupId = jsonObject.getLong("groupId");
        boolean privateLayout = jsonObject.getBoolean("privateLayout");
        long layoutId = jsonObject.getLong("layoutId");
        Layout layoutByUuidAndGroupId = this._layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        return layoutByUuidAndGroupId.getFriendlyURL();
    }

    private String _getLink(StructuredContentField structuredContentField) {
        return (String)Try.fromFallible(() -> structuredContentField.getLocalizedValue(LocaleUtil.getDefault())).filter(StructuredContentUtil::isJSONObject).filter(string -> string.contains("layoutId")).map(JSONFactoryUtil::createJSONObject).map(this::_getLayoutLink).orElse(null);
    }

    private Locale _getLocale(AcceptLanguage acceptLanguage, long contentSpaceId) throws PortalException {
        return Optional.ofNullable(acceptLanguage.getPreferredLocale()).orElse(this._portal.getSiteDefaultLocale(contentSpaceId));
    }

    private PageItems<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper> _getPageItems(Pagination pagination, long contentSpaceId, AcceptLanguage acceptLanguage, ThemeDisplay themeDisplay, Filter filter, com.liferay.portal.odata.sort.Sort sort) throws PortalException {
        Locale locale = this._getLocale(acceptLanguage, contentSpaceId);
        SearchContext searchContext = this._createSearchContext(themeDisplay.getCompanyId(), contentSpaceId, locale, sort, pagination.getStartPosition(), pagination.getEndPosition());
        Query fullQuery = this._getFullQuery(filter, locale, searchContext);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        Hits hits = null;
        if (permissionChecker != null) {
            if (searchContext.getUserId() == 0L) {
                searchContext.setUserId(permissionChecker.getUserId());
            }
            SearchResultPermissionFilter searchResultPermissionFilter = this._searchResultPermissionFilterFactory.create(searchContext1 -> IndexSearcherHelperUtil.search((SearchContext)searchContext1, (Query)fullQuery), permissionChecker);
            hits = searchResultPermissionFilter.search(searchContext);
        } else {
            hits = IndexSearcherHelperUtil.search((SearchContext)searchContext, (Query)fullQuery);
        }
        List journalArticleWrappers = Stream.of(this._journalHelper.getArticles(hits)).flatMap(Collection::stream).map(journalArticle -> new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper((JournalArticle)journalArticle, locale, themeDisplay)).collect(Collectors.toList());
        return new PageItems(journalArticleWrappers, hits.getLength());
    }

    private String _getRenderedContent(com.liferay.structured.content.apio.internal.model.JournalArticleWrapper journalArticleWrapper, DDMTemplate ddmTemplate) {
        Locale locale = journalArticleWrapper.getLocale();
        return (String)Try.fromFallible(() -> this._journalContent.getDisplay(journalArticleWrapper.getGroupId(), journalArticleWrapper.getArticleId(), ddmTemplate.getTemplateKey(), null, locale.toString(), journalArticleWrapper.getThemeDisplay())).map(JournalArticleDisplay::getContent).map(content -> content.replaceAll("[\\t\\n]", "")).orElse(null);
    }

    private List<RenderedJournalArticle> _getRenderedJournalArticles(com.liferay.structured.content.apio.internal.model.JournalArticleWrapper journalArticleWrapper) {
        DDMStructure ddmStructure = journalArticleWrapper.getDDMStructure();
        return Stream.of(ddmStructure.getTemplates()).flatMap(Collection::stream).map(ddmTemplate -> RenderedJournalArticle.create((Function<Locale, String>)((Function)arg_0 -> ((DDMTemplate)ddmTemplate).getName(arg_0)), (Function<Locale, String>)((Function)locale -> this._getRenderedContent(journalArticleWrapper, (DDMTemplate)ddmTemplate)))).collect(Collectors.toList());
    }

    private com.liferay.portal.kernel.search.filter.Filter _getSearchFilter(Filter filter, Locale locale) {
        if (filter == null || filter == Filter.emptyFilter()) {
            return null;
        }
        try {
            return (com.liferay.portal.kernel.search.filter.Filter)this._expressionConvert.convert(filter.getExpression(), locale, this._entityModel);
        }
        catch (Exception e) {
            throw new InvalidFilterException("Invalid filter: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<Sort> _getSorts(List<SortField> sortFields, Locale locale) {
        Stream stream = sortFields.stream();
        return stream.map(sortField -> new Sort(sortField.getSortableFieldName(locale), !sortField.isAscending())).collect(Collectors.toList());
    }

    private List<StructuredContentField> _getStructuredContentFields(JournalArticle journalArticle) {
        return (List)Try.fromFallible(() -> AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class)).map(assetRendererFactory -> assetRendererFactory.getAssetRenderer((Object)journalArticle, 1)).map(AssetRenderer::getDDMFormValuesReader).map(DDMFormValuesReader::getDDMFormValues).map(DDMFormValues::getDDMFormFieldValues).map(ddmFormFieldValueList -> this._toStructuredContentFields((List<DDMFormFieldValue>)ddmFormFieldValueList, journalArticle.getDDMStructure())).map(this::_getStructuredContentFields).orElse(null);
    }

    private List<StructuredContentField> _getStructuredContentFields(List<StructuredContentField> structuredContentFields) {
        Stream stream = structuredContentFields.stream();
        List<StructuredContentField> nestedStructureContentFields = stream.flatMap(structuredContentField -> this._getStructuredContentFields(structuredContentField.getNestedStructuredContentFields()).stream()).collect(Collectors.toList());
        nestedStructureContentFields.addAll(structuredContentFields);
        return nestedStructureContentFields;
    }

    private Long _getStructuredContentId(StructuredContentField structuredContentField) {
        return (Long)Try.fromFallible(() -> structuredContentField.getLocalizedValue(LocaleUtil.getDefault())).filter(StructuredContentUtil::isJSONObject).map(JSONFactoryUtil::createJSONObject).map(this::_getJournalArticle).map(JournalArticleModel::getResourcePrimKey).orElse(null);
    }

    private List<StructuredContentField> _toStructuredContentFields(List<DDMFormFieldValue> ddmFormFieldValues, DDMStructure ddmStructure) {
        Stream stream = ddmFormFieldValues.stream();
        return stream.filter(ddmFormFieldValue -> !Objects.equals("ddm-separator", ddmFormFieldValue.getType())).map(ddmFormFieldValue -> new StructuredContentFieldImpl((DDMFormFieldValue)ddmFormFieldValue, ddmStructure)).collect(Collectors.toList());
    }

    private com.liferay.structured.content.apio.internal.model.JournalArticleWrapper _updateJournalArticle(long journalArticleId, StructuredContentUpdaterForm structuredContentUpdaterForm, AcceptLanguage acceptLanguage, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(journalArticleId);
        ServiceContext serviceContext = structuredContentUpdaterForm.getServiceContext(journalArticle.getGroupId());
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Locale locale = this._getLocale(acceptLanguage, journalArticle.getGroupId());
        String content = this._journalArticleContentHelper.createJournalArticleContent(structuredContentUpdaterForm.getStructuredContentValuesForms(), ddmStructure, locale);
        String ddmTemplateKey = this._getDDMTemplateKey(ddmStructure);
        Date displayDate = journalArticle.getDisplayDate();
        JournalArticle updatedJournalArticle = this._journalArticleService.updateArticle(journalArticle.getGroupId(), journalArticle.getFolderId(), journalArticle.getArticleId(), journalArticle.getVersion(), this._getDefaultValue(structuredContentUpdaterForm.getTitleMapOptional(locale), journalArticle.getTitleMap()), this._getDefaultValue(structuredContentUpdaterForm.getDescriptionMapOptional(locale), journalArticle.getDescriptionMap()), journalArticle.getFriendlyURLMap(), content, journalArticle.getDDMStructureKey(), ddmTemplateKey, journalArticle.getLayoutUuid(), this._getDefaultValue(structuredContentUpdaterForm.getPublishedDateMonthOptional(), displayDate.getMonth()).intValue(), this._getDefaultValue(structuredContentUpdaterForm.getPublishedDateDayOptional(), displayDate.getDate()).intValue(), this._getDefaultValue(structuredContentUpdaterForm.getPublishedDateYearOptional(), displayDate.getYear()).intValue(), this._getDefaultValue(structuredContentUpdaterForm.getPublishedDateHourOptional(), displayDate.getHours()).intValue(), this._getDefaultValue(structuredContentUpdaterForm.getPublishedDateMinuteOptional(), displayDate.getMinutes()).intValue(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
        return new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper(updatedJournalArticle, locale, themeDisplay);
    }

    private class StructuredContentFieldImpl
    implements StructuredContentField {
        private final DDMFormFieldValue _ddmFormFieldValue;
        private final DDMStructure _ddmStructure;

        public StructuredContentFieldImpl(DDMFormFieldValue ddmFormFieldValue, DDMStructure ddmStructure) {
            this._ddmFormFieldValue = ddmFormFieldValue;
            this._ddmStructure = ddmStructure;
        }

        public String getDataType() {
            try {
                String dataType = this._ddmStructure.getFieldDataType(this._ddmFormFieldValue.getName());
                return StructuredContentNestedCollectionResource.this._structureFieldConverter.getFieldDataType(dataType);
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get data type for field name " + this._ddmFormFieldValue.getName()), (Throwable)pe);
                }
                return null;
            }
        }

        public String getFilterAndSortIdentifier() {
            Map entityFieldsMap = StructuredContentNestedCollectionResource.this._entityModel.getEntityFieldsMap();
            ComplexEntityField complexEntityField = (ComplexEntityField)entityFieldsMap.get(StructuredContentNestedCollectionResource.VALUES_NAME);
            Map complexEntityFieldEntityFieldsMap = complexEntityField.getEntityFieldsMap();
            EntityField entityField = (EntityField)complexEntityFieldEntityFieldsMap.get(StructuredContentNestedCollectionResource.encodeFilterAndSortIdentifier(this._ddmStructure, this._ddmFormFieldValue.getName()));
            if (entityField != null) {
                return entityField.getName();
            }
            return null;
        }

        public String getInputControl() {
            return (String)Try.fromFallible(() -> this._ddmStructure.getFieldType(this._ddmFormFieldValue.getName())).map(fieldType -> StructuredContentNestedCollectionResource.this._structureFieldConverter.getFieldInputControl(fieldType)).recover(pe -> {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get input control for field name " + this._ddmFormFieldValue.getName()), (Throwable)pe);
                }
                return null;
            });
        }

        public String getLocalizedLabel(Locale locale) {
            try {
                return this._ddmStructure.getFieldLabel(this._ddmFormFieldValue.getName(), locale);
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get localized label for value name ", this._ddmFormFieldValue.getName(), " and locale ", locale}), (Throwable)pe);
                }
                return null;
            }
        }

        public String getLocalizedValue(Locale locale) {
            Value value = this._ddmFormFieldValue.getValue();
            String localizedValue = value.getString(locale);
            if (!StructuredContentUtil.isJSONObject((String)localizedValue)) {
                return localizedValue;
            }
            return null;
        }

        public String getName() {
            return this._ddmFormFieldValue.getName();
        }

        public List<StructuredContentField> getNestedStructuredContentFields() {
            return StructuredContentNestedCollectionResource.this._toStructuredContentFields(this._ddmFormFieldValue.getNestedDDMFormFieldValues(), this._ddmStructure);
        }
    }
}

