/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structure.apio.internal.util;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureModel;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.structure.apio.architect.model.FormLayoutPage;
import com.liferay.structure.apio.architect.util.StructureFieldConverter;
import com.liferay.structure.apio.architect.util.StructureRepresentorBuilderHelper;
import com.liferay.structure.apio.internal.model.FormLayoutPageImpl;
import com.liferay.structure.apio.internal.util.LocalizedValueUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StructureRepresentorBuilderHelper.class})
public class StructureRepresentorBuilderHelperImpl
implements StructureRepresentorBuilderHelper {
    @Reference
    private StructureFieldConverter _structureFieldConverter;

    public NestedRepresentor.FirstStep<DDMFormField> buildDDMFormFieldFirstStep(NestedRepresentor.Builder<DDMFormField> builder) {
        return (NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormField", new String[0]).addBoolean("autocomplete", this.getDDMFormFieldPropertyFunction(Boolean.class::cast, "autocomplete"))).addBoolean("inline", this.getDDMFormFieldPropertyFunction(Boolean.class::cast, "inline"))).addBoolean("localizable", DDMFormField::isLocalizable)).addBoolean("multiple", DDMFormField::isMultiple)).addBoolean("readOnly", DDMFormField::isReadOnly)).addBoolean("repeatable", DDMFormField::isRepeatable)).addBoolean("required", DDMFormField::isRequired)).addBoolean("showAsSwitcher", this.getDDMFormFieldPropertyFunction(Boolean.class::cast, "showAsSwitcher"))).addBoolean("showLabel", DDMFormField::isShowLabel)).addLocalizedStringByLocale("label", LocalizedValueUtil.getLocalizedString(DDMFormField::getLabel))).addLocalizedStringByLocale("placeholder", this.getLocalizedStringBiFunction("placeholder"))).addLocalizedStringByLocale("predefinedValue", LocalizedValueUtil.getLocalizedString(DDMFormField::getPredefinedValue))).addLocalizedStringByLocale("style", LocalizedValueUtil.getLocalizedString(DDMFormField::getStyle))).addLocalizedStringByLocale("tooltip", LocalizedValueUtil.getLocalizedString(DDMFormField::getTip))).addNested("validation", DDMFormField::getDDMFormFieldValidation, StructureRepresentorBuilderHelperImpl::_buildValidationProperties)).addNestedList("options", this.getLocalizedValueEntriesFunction(DDMFormField::getDDMFormFieldOptions), this::_buildFieldOptions)).addString("dataSourceType", this.getDDMFormFieldPropertyFunction(String.class::cast, "dataSourceType"))).addString("dataType", this::_getDDMFormFieldDataType)).addString("displayStyle", this.getDDMFormFieldPropertyFunction(String.class::cast, "displayStyle"))).addString("inputControl", this::_getDDMFormFieldInputControl)).addString("name", DDMFormField::getName)).addString("text", this.getDDMFormFieldPropertyFunction(String.class::cast, "text"));
    }

    public Representor.FirstStep<DDMStructure> buildDDMStructureFirstStep(Representor.Builder<DDMStructure, Long> builder) {
        return (Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("Structure", new String[0]).identifier(DDMStructureModel::getStructureId).addDate("dateCreated", DDMStructureModel::getCreateDate)).addDate("dateModified", DDMStructureModel::getCreateDate)).addLinkedModel("creator", PersonIdentifier.class, DDMStructureModel::getUserId)).addLocalizedStringByLocale("description", DDMStructureModel::getDescription)).addLocalizedStringByLocale("name", DDMStructureModel::getName)).addStringList("availableLanguages", ddmStructure -> Arrays.asList(LocaleUtil.toW3cLanguageIds((String[])ddmStructure.getAvailableLanguageIds())));
    }

    public NestedRepresentor.FirstStep<FormLayoutPage> buildFormLayoutPageFirstStep(NestedRepresentor.Builder<FormLayoutPage> builder) {
        return (NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormLayoutPage", new String[0]).addLocalizedStringByLocale("headline", FormLayoutPage::getTitle)).addLocalizedStringByLocale("text", FormLayoutPage::getDescription);
    }

    public <T> Function<DDMFormField, T> getDDMFormFieldPropertyFunction(Function<Object, T> parseFunction, String key) {
        return ddmFormField -> Try.fromFallible(() -> ddmFormField.getProperty(key)).map(parseFunction::apply).orElse(null);
    }

    public List<FormLayoutPage> getFormLayoutPages(DDMStructure ddmStructure) {
        return ((Stream)Try.fromFallible(() -> ((DDMStructure)ddmStructure).getDDMFormLayout()).map(DDMFormLayout::getDDMFormLayoutPages).map(Collection::stream).orElseGet(Stream::empty)).map(StructureRepresentorBuilderHelperImpl._getFormLayoutPageFunction(ddmStructure)).collect(Collectors.toList());
    }

    public BiFunction<DDMFormField, Locale, String> getLocalizedStringBiFunction(String key) {
        return LocalizedValueUtil.getLocalizedString(ddmFormField -> (LocalizedValue)ddmFormField.getProperty(key));
    }

    public Function<DDMFormField, List<Map.Entry<String, LocalizedValue>>> getLocalizedValueEntriesFunction(Function<DDMFormField, DDMFormFieldOptions> function) {
        return ddmFormField -> (ArrayList)Try.fromFallible(() -> (DDMFormFieldOptions)function.apply((DDMFormField)ddmFormField)).map(DDMFormFieldOptions::getOptions).map(Map::entrySet).map(ArrayList::new).orElse(null);
    }

    public Function<DDMFormField, List<Map.Entry<String, LocalizedValue>>> getLocalizedValueEntriesFunction(String key) {
        return this.getLocalizedValueEntriesFunction((DDMFormField ddmFormField) -> (DDMFormFieldOptions)ddmFormField.getProperty(key));
    }

    private static NestedRepresentor<DDMFormFieldValidation> _buildValidationProperties(NestedRepresentor.Builder<DDMFormFieldValidation> builder) {
        return (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormFieldProperties", new String[0]).addString("errorMessage", DDMFormFieldValidation::getErrorMessage)).addString("expression", DDMFormFieldValidation::getExpression)).build();
    }

    private static List<String> _getFieldNames(DDMFormLayoutPage ddmFormLayoutPage, DDMStructure ddmStructure) {
        return Optional.ofNullable(ddmFormLayoutPage.getDDMFormLayoutRows()).map(Collection::stream).orElseGet(Stream::empty).map(DDMFormLayoutRow::getDDMFormLayoutColumns).flatMap(Collection::stream).map(DDMFormLayoutColumn::getDDMFormFieldNames).map(formFieldNames -> StructureRepresentorBuilderHelperImpl._getNestedFieldNames(formFieldNames, ddmStructure)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Function<List<String>, List<DDMFormField>> _getFieldsPerPageFunction(DDMStructure ddmStructure) {
        return fieldNamesPerPage -> ((Stream)Try.fromFallible(() -> ddmStructure.getDDMFormFields(true)).map(Collection::stream).orElseGet(Stream::empty)).filter(ddmFormField -> fieldNamesPerPage.contains(ddmFormField.getName())).collect(Collectors.toList());
    }

    private static Function<DDMFormLayoutPage, FormLayoutPage> _getFormLayoutPageFunction(DDMStructure ddmStructure) {
        return ddmFormLayoutPage -> Optional.ofNullable(StructureRepresentorBuilderHelperImpl._getFieldNames(ddmFormLayoutPage, ddmStructure)).map(StructureRepresentorBuilderHelperImpl._getFieldsPerPageFunction(ddmStructure)).map(ddmFormFields -> new FormLayoutPageImpl((DDMFormLayoutPage)ddmFormLayoutPage, (List<DDMFormField>)ddmFormFields)).orElse(null);
    }

    private static List<String> _getNestedFieldNames(List<String> ddmFormFieldNames, DDMStructure ddmStructure) {
        List ddmFormFields = ddmStructure.getDDMFormFields(true);
        Stream ddmFormFieldStream = ddmFormFields.stream();
        return ddmFormFieldStream.filter(formField -> ddmFormFieldNames.contains(formField.getName())).map(formField -> formField.getNestedDDMFormFields().stream().map(DDMFormField::getName).collect(Collectors.toList())).map(fieldNames -> StructureRepresentorBuilderHelperImpl._getNestedFieldNames(fieldNames, ddmStructure)).peek(fieldNames -> fieldNames.addAll(ddmFormFieldNames)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private NestedRepresentor<Map.Entry<String, LocalizedValue>> _buildFieldOptions(NestedRepresentor.Builder<Map.Entry<String, LocalizedValue>> builder) {
        return (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormFieldOptions", new String[0]).addLocalizedStringByLocale("label", LocalizedValueUtil.getLocalizedString(Map.Entry::getValue))).addString("value", Map.Entry::getKey)).build();
    }

    private String _getDDMFormFieldDataType(DDMFormField ddmFormField) {
        return this._structureFieldConverter.getFieldDataType(ddmFormField.getDataType(), ddmFormField.getType());
    }

    private String _getDDMFormFieldInputControl(DDMFormField ddmFormField) {
        return this._structureFieldConverter.getFieldInputControl(ddmFormField.getType());
    }
}

