/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GenericTypeCheck
extends BaseCheck {
    private static final String _GENERIC_TYPE_NAMES_CATEGORY = "genericTypeNames";
    private static final String _GENERIC_TYPE_NAMES_FILE_NAME = "generic-type-names.json";
    private static final String _MSG_PARAMETERIZE_GENERIC_TYPE = "generic.type.parameterize";
    private static final String _POPULATE_TYPE_NAMES_KEY = "populateTypeNames";
    private Tuple _genericTypeNamesTuple;

    public int[] getDefaultTokens() {
        return new int[]{9, 21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkType(detailAST, detailAST.findFirstToken(13));
    }

    private void _checkType(DetailAST detailAST, DetailAST typeDetailAST) {
        DetailAST parentDetailAST;
        if (typeDetailAST == null || detailAST.findFirstToken(171) != null) {
            return;
        }
        DetailAST identDetailAST = typeDetailAST.findFirstToken(58);
        if (identDetailAST == null) {
            return;
        }
        DetailAST typeArgumentsDetailAST = typeDetailAST.findFirstToken(163);
        if (typeArgumentsDetailAST != null) {
            List<DetailAST> typeArgumentDetailASTList = this.getAllChildTokens(typeArgumentsDetailAST, false, 164);
            if (this.isAttributeValue(_POPULATE_TYPE_NAMES_KEY)) {
                this._populateGenericTypeNames(typeDetailAST, typeArgumentDetailASTList);
            }
            for (DetailAST typeArgumentDetailAST : typeArgumentDetailASTList) {
                this._checkType(detailAST, typeArgumentDetailAST);
            }
            return;
        }
        String genericTypeName = this._getGenericTypeName(typeDetailAST);
        if (genericTypeName == null || detailAST.getType() == 9 && AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return;
        }
        if (detailAST.getType() == 21 && (parentDetailAST = this.getParentWithTokenType(detailAST, 9, 8)) != null && AnnotationUtil.containsAnnotation((DetailAST)parentDetailAST, (String)"Override")) {
            return;
        }
        for (parentDetailAST = typeDetailAST; parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (!this._hasSuppressWarningsAnnotation(parentDetailAST, "rawtypes")) continue;
            return;
        }
        Map<String, Integer> genericTypeNamesMap = this._getGenericTypeNamesMap();
        int genericTypeCount = GetterUtil.getInteger(genericTypeNamesMap.get(genericTypeName));
        if (genericTypeCount == 1) {
            this.log(typeDetailAST, _MSG_PARAMETERIZE_GENERIC_TYPE, new Object[]{"type", genericTypeName});
        } else {
            this.log(typeDetailAST, _MSG_PARAMETERIZE_GENERIC_TYPE, new Object[]{"types", genericTypeName});
        }
    }

    private String _getGenericTypeName(DetailAST typeDetailAST) {
        Map<String, Integer> genericTypeNamesMap = this._getGenericTypeNamesMap();
        String typeName = this.getFullyQualifiedTypeName(typeDetailAST, false);
        if (typeName != null && genericTypeNamesMap.containsKey(typeName)) {
            return typeName;
        }
        typeName = this.getTypeName(typeDetailAST, false);
        if (genericTypeNamesMap.containsKey("java.lang." + typeName)) {
            return "java.lang." + typeName;
        }
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        typeName = JavaSourceUtil.getPackageName((String)fileText.getFullText()) + ".." + typeName;
        if (genericTypeNamesMap.containsKey(typeName)) {
            return typeName;
        }
        return null;
    }

    private Map<String, Integer> _getGenericTypeNamesMap() {
        Tuple genericTypeNamesTuple = this._getGenericTypeNamesTuple();
        JSONObject jsonObject = (JSONObject)genericTypeNamesTuple.getObject(0);
        JSONArray jsonArray = (JSONArray)jsonObject.get(_GENERIC_TYPE_NAMES_CATEGORY);
        TreeMap<String, Integer> genericTypeNamesMap = new TreeMap<String, Integer>();
        for (Object object : JSONUtil.toObjectList(jsonArray)) {
            jsonObject = (JSONObject)object;
            genericTypeNamesMap.put(jsonObject.getString("name"), jsonObject.getInt("genericTypeCount"));
        }
        return genericTypeNamesMap;
    }

    private synchronized Tuple _getGenericTypeNamesTuple() {
        if (this._genericTypeNamesTuple != null) {
            return this._genericTypeNamesTuple;
        }
        this._genericTypeNamesTuple = this.getTypeNamesTuple(_GENERIC_TYPE_NAMES_FILE_NAME, _GENERIC_TYPE_NAMES_CATEGORY);
        return this._genericTypeNamesTuple;
    }

    private boolean _hasSuppressWarningsAnnotation(DetailAST detailAST, String warning) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST == null) {
            return false;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"SuppressWarnings");
        if (annotationDetailAST == null) {
            return false;
        }
        List<DetailAST> literalStringDetailASTList = this.getAllChildTokens(annotationDetailAST, true, 139);
        for (DetailAST literalStringDetailAST : literalStringDetailASTList) {
            String s = literalStringDetailAST.getText();
            if (!s.equals("\"" + warning + "\"")) continue;
            return true;
        }
        return false;
    }

    private void _populateGenericTypeNames(DetailAST typeDetailAST, List<DetailAST> typeArgumentDetailASTList) {
        Tuple genericTypeNamesTuple = this._getGenericTypeNamesTuple();
        File genericTypeNamesFile = (File)genericTypeNamesTuple.getObject(1);
        if (genericTypeNamesFile == null) {
            return;
        }
        for (DetailAST typeArgumentDetailAST : typeArgumentDetailASTList) {
            String name;
            DetailAST firstChildDetailAST = typeArgumentDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 167) {
                return;
            }
            if (firstChildDetailAST.getType() != 58 || (name = firstChildDetailAST.getText()).length() != 1) continue;
            return;
        }
        Map<String, Integer> genericTypeNamesMap = this._getGenericTypeNamesMap();
        String typeName = this.getFullyQualifiedTypeName(typeDetailAST, false);
        if (typeName == null || genericTypeNamesMap.containsKey(typeName)) {
            return;
        }
        genericTypeNamesMap.put(typeName, typeArgumentDetailASTList.size());
        try {
            JSONObjectImpl jsonObject = new JSONObjectImpl();
            JSONArrayImpl jsonArray = new JSONArrayImpl();
            for (Map.Entry<String, Integer> entry : genericTypeNamesMap.entrySet()) {
                JSONObjectImpl curJSONObject = new JSONObjectImpl();
                curJSONObject.put("genericTypeCount", entry.getValue()).put("name", entry.getKey());
                jsonArray.put(curJSONObject);
            }
            jsonObject.put(_GENERIC_TYPE_NAMES_CATEGORY, jsonArray);
            FileUtil.write(genericTypeNamesFile, JSONUtil.toString(jsonObject));
            System.out.println(StringBundler.concat("Added '", typeName, "' to '", _GENERIC_TYPE_NAMES_FILE_NAME, "'"));
            this._genericTypeNamesTuple = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

