/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import java.util.regex.Pattern;

public class PoshiIndentationCheck
extends BaseFileCheck {
    private static final Pattern _multiLineCommentsPattern = Pattern.compile("[ \t]/\\*.*?\\*/", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int level = 0;
            int lineNumber = 0;
            String line = null;
            boolean insideMultiLineString = false;
            int[] multiLineCommentsPositions = SourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (SourceUtil.isInsideMultiLines(++lineNumber, multiLineCommentsPositions)) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                if (!insideMultiLineString) {
                    sb.append(this._fixIndentation(line, level));
                    sb.append("\n");
                    String s = StringUtil.removeSubstrings(line, "\\");
                    if (StringUtil.count(line, "'''") == 1) {
                        insideMultiLineString = true;
                        int x = line.indexOf("(");
                        int y = line.indexOf("'''");
                        if (x == -1 || x >= y) continue;
                        s = StringUtil.removeSubstrings(line, "'''");
                        level += this.getLevel(s, new String[]{"(", "{"}, new String[]{")", "}"});
                        continue;
                    }
                    if (line.matches(".*?'''[({)}]'''.*")) continue;
                    s = s.replaceFirst("([^']*)('''.*''')([^']*)", "$1$3");
                    level += this.getLevel(s, new String[]{"(", "{"}, new String[]{")", "}"});
                    continue;
                }
                sb.append(line);
                sb.append("\n");
                if (StringUtil.count(line, "'''") != 1) continue;
                insideMultiLineString = false;
                if (!line.endsWith("''');")) continue;
                level += this.getLevel(")", new String[]{"(", "{"}, new String[]{")", "}"});
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _fixIndentation(String line, int level) {
        String trimmedLine = StringUtil.trim(line);
        if (Validator.isNull(trimmedLine)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (int i = 0; i < level && (i != level - 1 || !trimmedLine.startsWith(")") && !trimmedLine.startsWith("}")); ++i) {
            sb.append('\t');
        }
        sb.append(trimmedLine);
        return sb.toString();
    }
}

