/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPSourceUtil {
    private static final Pattern _includeFilePattern = Pattern.compile("\\s*@\\s*include\\s*file=['\"](.*)['\"]");
    private static final Pattern _javaCodeTagPattern = Pattern.compile("<%\\s*[@=\n]");
    private static final Pattern _javaEndTagPattern = Pattern.compile("[\n\t]%>(\n|\\Z)");
    private static final Pattern _javaStartTagPattern = Pattern.compile("[\n\t]<%\\!?(\n|\\Z)");
    private static final Pattern _jspIncludeFilePattern = Pattern.compile("/.*\\.(jsp[f]?|svg|tag)");

    public static List<String> addIncludedAndReferencedFileNames(List<String> fileNames, Set<String> checkedFileNames, Map<String, String> contentsMap, String referencedFileNameRegex) {
        HashSet<String> includedAndReferencedFileNames = new HashSet<String>();
        for (String fileName : fileNames) {
            if (!checkedFileNames.add(fileName)) continue;
            fileName = StringUtil.replace(fileName, '\\', '/');
            includedAndReferencedFileNames.addAll(JSPSourceUtil.getJSPIncludeFileNames(fileName, fileNames, contentsMap, true));
            includedAndReferencedFileNames.addAll(JSPSourceUtil.getJSPReferenceFileNames(fileName, fileNames, contentsMap, referencedFileNameRegex));
        }
        if (includedAndReferencedFileNames.isEmpty()) {
            return fileNames;
        }
        for (String fileName : includedAndReferencedFileNames) {
            if (fileNames.contains(fileName = StringUtil.replace(fileName, '/', '\\'))) continue;
            fileNames.add(fileName);
        }
        return JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, checkedFileNames, contentsMap, referencedFileNameRegex);
    }

    public static String buildFullPathIncludeFileName(String fileName, String includeFileName, Map<String, String> contentsMap) {
        String path = fileName;
        int y;
        while ((y = path.lastIndexOf(47)) != -1) {
            String fullPathIncludeFileName = path.substring(0, y) + includeFileName;
            if (contentsMap.containsKey(fullPathIncludeFileName) && !fullPathIncludeFileName.equals(fileName)) {
                return fullPathIncludeFileName;
            }
            path = path.substring(0, y);
        }
        return "";
    }

    public static String compressImportsOrTaglibs(String fileName, String content, String attributePrefix) {
        int x = content.indexOf(attributePrefix);
        int y = content.lastIndexOf(attributePrefix);
        y = content.indexOf("%>", y);
        if (x == -1 || y == -1 || x > y) {
            return content;
        }
        String importsOrTaglibs = content.substring(x, y);
        importsOrTaglibs = StringUtil.replace(importsOrTaglibs, new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, new String[]{"%><%@\r\n", "%><%@\n"});
        return content.substring(0, x) + importsOrTaglibs + content.substring(y);
    }

    public static Map<String, String> getContentsMap(List<String> fileNames) throws IOException {
        ConcurrentHashMap<String, String> contentsMap = new ConcurrentHashMap<String, String>();
        if (ListUtil.isEmpty(fileNames)) {
            return contentsMap;
        }
        for (String fileName : fileNames) {
            File file = new File(fileName = StringUtil.replace(fileName, '\\', '/'));
            String content = FileUtil.read(file);
            if (content == null) continue;
            Matcher matcher = _includeFilePattern.matcher(content);
            while (matcher.find()) {
                content = StringUtil.replaceFirst(content, matcher.group(), "@ include file=\"" + matcher.group(1) + "\"", matcher.start());
            }
            contentsMap.put(fileName, content);
        }
        return contentsMap;
    }

    public static Set<String> getJSPIncludeFileNames(String fileName, Collection<String> fileNames, Map<String, String> contentsMap, boolean forceIncludeAllFiles) {
        HashSet<String> includeFileNames = new HashSet<String>();
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return includeFileNames;
        }
        int x = -1;
        while ((x = content.indexOf("<%@ include file=", x + 1)) != -1) {
            Matcher matcher;
            int y;
            Matcher matcher2;
            if (!forceIncludeAllFiles && (matcher2 = _javaCodeTagPattern.matcher(content)).find() && matcher2.start() == x) continue;
            if ((x = content.indexOf(34, x)) == -1 || (y = content.indexOf(34, x + 1)) == -1) break;
            String includeFileName = content.substring(x + 1, y);
            if (!includeFileName.startsWith("/")) {
                includeFileName = "/" + includeFileName;
            }
            if (!(matcher = _jspIncludeFilePattern.matcher(includeFileName)).find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            String extension = matcher.group(1);
            if (extension.equals("svg") || !(includeFileName = JSPSourceUtil.buildFullPathIncludeFileName(fileName, includeFileName, contentsMap)).endsWith("jsp") && !includeFileName.endsWith("jspf") && !includeFileName.endsWith("tag") || fileNames.contains(includeFileName)) continue;
            includeFileNames.add(includeFileName);
        }
        return includeFileNames;
    }

    public static Set<String> getJSPReferenceFileNames(String fileName, Collection<String> fileNames, Map<String, String> contentsMap, String referencedFileNameRegex) {
        HashSet<String> referenceFileNames = new HashSet<String>();
        if (!fileName.matches(referencedFileNameRegex)) {
            return referenceFileNames;
        }
        block0: for (Map.Entry<String, String> entry : contentsMap.entrySet()) {
            String sharedPath;
            String referenceFileName = entry.getKey();
            if (fileNames.contains(referenceFileName) || Validator.isNull(sharedPath = fileName.substring(0, StringUtil.startsWithWeight(referenceFileName, fileName))) || !sharedPath.contains("/")) continue;
            if (!sharedPath.endsWith("/")) {
                sharedPath = sharedPath.substring(0, sharedPath.lastIndexOf(47) + 1);
            }
            String content = null;
            int x = -1;
            while ((x = sharedPath.indexOf(47, x + 1)) != -1) {
                if (content == null) {
                    content = entry.getValue();
                }
                if (!content.contains("<%@ include file=\"" + fileName.substring(x)) && !content.contains("<%@ include file=\"" + fileName.substring(x + 1))) continue;
                referenceFileNames.add(referenceFileName);
                continue block0;
            }
        }
        return referenceFileNames;
    }

    public static boolean isJavaSource(String content, int pos) {
        return JSPSourceUtil.isJavaSource(content, pos, false);
    }

    public static boolean isJavaSource(String content, int pos, boolean checkInsideTags) {
        String s = content.substring(pos);
        Matcher matcher = _javaEndTagPattern.matcher(s);
        if (matcher.find() && !(matcher = _javaStartTagPattern.matcher(s = s.substring(0, matcher.start()))).find()) {
            return true;
        }
        if (!checkInsideTags) {
            return false;
        }
        int x = content.indexOf(10, pos);
        if (x == -1) {
            return false;
        }
        s = content.substring(pos, x);
        int y = s.indexOf("%>");
        if (y == -1) {
            return false;
        }
        return !(s = s.substring(0, y)).contains("<%");
    }
}

