/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class PropertiesLanguageKeysCheck
extends BaseFileCheck {
    private static final String _ALLOWED_LANGUAGE_KEYS_KEY = "allowedLanguageKeys";
    private static final String _PORTAL_IMPL_LANGUAGE_PROPERTIES_FILE_NAME = "portal-impl/src/content/Language.properties";
    private Properties _portalImplLanguageProperties;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/content/Language.properties")) {
            return content;
        }
        StringBundler sb = new StringBundler();
        Properties portalImplLanguageProperties = this._getPortalImplLanguageProperties(absolutePath);
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String portalImplValue;
                String[] array = line.split("=", 2);
                if (array.length < 2) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                String key = array[0];
                String value = array[1];
                if (portalImplLanguageProperties != null && !absolutePath.contains("/private/apps/") && value.equals(portalImplValue = portalImplLanguageProperties.getProperty(key))) continue;
                if (!this._isAllowedLanguageKey(key, absolutePath) && value.matches("(?s).*<([a-zA-Z0-9]+)[^>]*>.*?<\\/\\1>.*")) {
                    this.addMessage(fileName, "Remove HTML markup for '" + key + "'", "language_keys.markdown", this.getLineNumber(content, content.indexOf(line)));
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private Properties _getPortalImplLanguageProperties(String absolutePath) throws IOException {
        if (absolutePath.endsWith(_PORTAL_IMPL_LANGUAGE_PROPERTIES_FILE_NAME)) {
            return null;
        }
        if (this._portalImplLanguageProperties != null) {
            return this._portalImplLanguageProperties;
        }
        Properties portalImplLanguageProperties = new Properties();
        InputStream inputStream = this.getPortalInputStream(_PORTAL_IMPL_LANGUAGE_PROPERTIES_FILE_NAME, absolutePath);
        if (inputStream != null) {
            portalImplLanguageProperties.load(inputStream);
        }
        this._portalImplLanguageProperties = portalImplLanguageProperties;
        return this._portalImplLanguageProperties;
    }

    private boolean _isAllowedLanguageKey(String key, String absolutePath) {
        String s = key.replaceAll("[^\\w.-]", "");
        List<String> allowedLanguageKeys = this.getAttributeValues(_ALLOWED_LANGUAGE_KEYS_KEY, absolutePath);
        for (String allowedLanguageKey : allowedLanguageKeys) {
            if (!s.equals(allowedLanguageKey)) continue;
            return true;
        }
        return false;
    }
}

