/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaReleaseInfoCheck
extends BaseJavaTermCheck {
    private static final Pattern _releaseBuildNumberPattern = Pattern.compile("^RELEASE_([0-9_]+)_BUILD_NUMBER$");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        String javaTermContent = javaTerm.getContent();
        if (!absolutePath.contains("/kernel/util/ReleaseInfo.java")) {
            return javaTermContent;
        }
        String variableName = javaTerm.getName();
        if (variableName.equals("_BUILD")) {
            javaTermContent = this._formatBuild(fileName, javaTerm);
        } else if (variableName.equals("_VERSION")) {
            this._checkMissingReleaseBuildNumber(fileName, javaTerm);
        } else if (variableName.equals("_VERSION_DISPLAY_NAME")) {
            javaTermContent = this._formatVersionDisplayName(javaTerm);
        } else {
            Matcher matcher = _releaseBuildNumberPattern.matcher(variableName);
            if (matcher.find()) {
                return this._formatReleaseBuildNumber(javaTerm, new ReleaseVersion(matcher.group(1), "_"));
            }
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_VARIABLE};
    }

    private void _checkMissingReleaseBuildNumber(String fileName, JavaTerm javaTerm) {
        ReleaseVersion releaseVersion = new ReleaseVersion(this._getVariableValue(javaTerm.getContent()));
        String releaseBuildNumberVariableName = StringBundler.concat("RELEASE_", releaseVersion.toString("_"), "_BUILD_NUMBER");
        JavaVariable releaseBuildNumberJavaVariable = this._getJavaVariable(javaTerm, releaseBuildNumberVariableName);
        if (releaseBuildNumberJavaVariable == null) {
            this.addMessage(fileName, StringBundler.concat("Missing variable '", releaseBuildNumberVariableName, "'"));
        }
    }

    private String _formatBuild(String fileName, JavaTerm javaTerm) {
        String latestReleaseVersionBuild;
        ReleaseVersion latestReleaseVersion = this._getLatestReleaseVersion(javaTerm);
        if (latestReleaseVersion == null) {
            this.addMessage(fileName, "Missing variable '_VERSION'");
            return javaTerm.getContent();
        }
        String buildValue = this._getVariableValue(javaTerm.getContent());
        if (!buildValue.equals(latestReleaseVersionBuild = latestReleaseVersion.toString())) {
            return StringUtil.replaceLast(javaTerm.getContent(), buildValue, latestReleaseVersionBuild);
        }
        return javaTerm.getContent();
    }

    private String _formatReleaseBuildNumber(JavaTerm javaTerm, ReleaseVersion releaseVersion) {
        String expectedReleaseBuildNumberValue;
        String actualReleaseBuildNumberValue = this._getVariableValue(javaTerm.getContent());
        if (!actualReleaseBuildNumberValue.equals(expectedReleaseBuildNumberValue = releaseVersion.toString())) {
            return StringUtil.replaceLast(javaTerm.getContent(), actualReleaseBuildNumberValue, expectedReleaseBuildNumberValue);
        }
        return javaTerm.getContent();
    }

    private String _formatVersionDisplayName(JavaTerm javaTerm) {
        String versionDisplayNameValue = this._getVariableValue(javaTerm.getContent());
        Object[] versionDisplayNameParts = StringUtil.split(versionDisplayNameValue, ' ');
        if (!ArrayUtil.contains(versionDisplayNameParts, "CE")) {
            return javaTerm.getContent();
        }
        Object actualVersionNumber = versionDisplayNameParts[0];
        ReleaseVersion latestReleaseVersion = this._getLatestReleaseVersion(javaTerm);
        String expectedVersionNumber = latestReleaseVersion.toString(".");
        String newVersionDisplayNameValue = StringUtil.replaceFirst(versionDisplayNameValue, (String)actualVersionNumber, expectedVersionNumber);
        Object actualReleaseType = versionDisplayNameParts[versionDisplayNameParts.length - 1];
        int microVersion = GetterUtil.getInteger(latestReleaseVersion.getMicroVersion());
        if (microVersion > 0 || ((String)actualReleaseType).startsWith("GA")) {
            String expectedReleaseType = "GA" + (microVersion + 1);
            newVersionDisplayNameValue = StringUtil.replaceLast(newVersionDisplayNameValue, (String)actualReleaseType, expectedReleaseType);
        }
        if (versionDisplayNameValue.equals(newVersionDisplayNameValue)) {
            return javaTerm.getContent();
        }
        return StringUtil.replaceLast(javaTerm.getContent(), versionDisplayNameValue, newVersionDisplayNameValue);
    }

    private JavaVariable _getJavaVariable(JavaTerm javaTerm, String name) {
        JavaClass javaClass = javaTerm.getParentJavaClass();
        for (JavaTerm curJavaTerm : javaClass.getChildJavaTerms()) {
            if (!(curJavaTerm instanceof JavaVariable) || !name.equals(curJavaTerm.getName())) continue;
            return (JavaVariable)curJavaTerm;
        }
        return null;
    }

    private ReleaseVersion _getLatestReleaseVersion(JavaTerm javaTerm) {
        JavaVariable versionJavaVariable = this._getJavaVariable(javaTerm, "_VERSION");
        if (versionJavaVariable == null) {
            return null;
        }
        String versionValue = this._getVariableValue(versionJavaVariable.getContent());
        return new ReleaseVersion(versionValue);
    }

    private String _getVariableValue(String variableContent) {
        variableContent = StringUtil.trim(variableContent);
        int x = variableContent.length() + 1;
        do {
            if ((x = variableContent.lastIndexOf("=", x - 1)) != -1) continue;
            return null;
        } while (ToolsUtil.isInsideQuotes(variableContent, x));
        String variableValue = StringUtil.trim(variableContent.substring(x + 1, variableContent.length() - 1));
        if (variableValue.startsWith("\"") && variableValue.endsWith("\"")) {
            return variableValue.substring(1, variableValue.length() - 1);
        }
        return variableValue;
    }

    private class ReleaseVersion {
        private String _majorVersion;
        private String _microVersion;
        private String _minorVersion;

        public ReleaseVersion(String version) {
            this(version, ".");
        }

        public ReleaseVersion(String version, String delimeter) {
            int x = version.indexOf(delimeter);
            if (x == -1) {
                return;
            }
            this._majorVersion = version.substring(0, x);
            int y = version.indexOf(delimeter, x + 1);
            if (y == -1) {
                return;
            }
            this._microVersion = version.substring(y + 1);
            this._minorVersion = version.substring(x + 1, y);
        }

        public String getMicroVersion() {
            return this._microVersion;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String delimeter) {
            if (delimeter == null) {
                return StringBundler.concat(this._majorVersion, this._minorVersion, String.format("%02d", GetterUtil.getInteger(this._microVersion)));
            }
            return StringBundler.concat(this._majorVersion, delimeter, this._minorVersion, delimeter, this._microVersion);
        }
    }
}

