/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;

public class JSONDeprecatedPackagesCheck
extends BaseFileCheck {
    private static final String[] _DEPRECATED_PACKAGE_NAMES = new String[]{"liferay-module-config-generator", "metal-cli"};

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith("/package.json")) {
            return content;
        }
        for (String deprecatedPackageName : _DEPRECATED_PACKAGE_NAMES) {
            int x = -1;
            while ((x = content.indexOf("\"" + deprecatedPackageName + "\":", x + 1)) != -1) {
                int lineNumber = SourceUtil.getLineNumber(content, x);
                this.addMessage(fileName, "Do not use deprecated package '" + deprecatedPackageName + "'", lineNumber);
            }
        }
        return content;
    }
}

