/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class StringBundlerNamingCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_VARIABLE_NAME = "variable.name.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String typeName = DetailASTUtil.getTypeName(detailAST, false);
        if (!typeName.equals("StringBundler")) {
            return;
        }
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST.branchContains(63) || modifiersDetailAST.branchContains(62)) {
            return;
        }
        String name = this._getName(detailAST);
        if (!name.matches("_?(sb|.*SB)([0-9]*)?")) {
            this.log(detailAST, _MSG_INCORRECT_VARIABLE_NAME, new Object[]{this._getTokenTypeName(detailAST), name});
        }
    }

    private String _getName(DetailAST detailAST) {
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        return nameDetailAST.getText();
    }

    private String _getTokenTypeName(DetailAST detailAST) {
        if (detailAST.getType() == 21) {
            return "parameter";
        }
        return "variable";
    }
}

