/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class PropertiesPortalFileCheck
extends BaseFileCheck {
    private String _portalPortalPropertiesContent;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if ((this.isPortalSource() || this.isSubrepository()) && fileName.matches(".*portal-legacy-.*\\.properties") || !this.isPortalSource() && !this.isSubrepository() && fileName.endsWith("portal.properties")) {
            this._checkPortalProperties(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkPortalProperties(String fileName, String absolutePath, String content) throws IOException {
        String portalPortalPropertiesContent = this._getPortalPortalPropertiesContent(absolutePath);
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            int previousPos = -1;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                int pos = line.indexOf(61);
                if (pos == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos + 1));
                pos = portalPortalPropertiesContent.indexOf("    " + property);
                if (pos == -1) continue;
                if (pos < previousPos) {
                    this.addMessage(fileName, "Follow order as in portal-impl/src/portal.properties", lineNumber);
                }
                previousPos = pos;
            }
        }
    }

    private synchronized String _getPortalPortalPropertiesContent(String absolutePath) throws IOException {
        if (this._portalPortalPropertiesContent != null) {
            return this._portalPortalPropertiesContent;
        }
        if (this.isPortalSource() || this.isSubrepository()) {
            this._portalPortalPropertiesContent = this.getPortalContent("portal-impl/src/portal.properties", absolutePath);
            if (this._portalPortalPropertiesContent == null) {
                this._portalPortalPropertiesContent = "";
            }
            return this._portalPortalPropertiesContent;
        }
        ClassLoader classLoader = PropertiesSourceProcessor.class.getClassLoader();
        URL url = classLoader.getResource("portal.properties");
        this._portalPortalPropertiesContent = url != null ? IOUtils.toString((URL)url) : "";
        return this._portalPortalPropertiesContent;
    }
}

