/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;

public class JSONLineBreakCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        for (int i = 0; i < content.length(); ++i) {
            char nextChar;
            if (ToolsUtil.isInsideQuotes(content, i)) continue;
            char c = content.charAt(i);
            if (i < content.length() - 1 && (nextChar = content.charAt(i + 1)) != '\n' && (c == '[' && nextChar != ']' || c == '{' && nextChar != '}' || c == ',')) {
                return StringUtil.insert(content, "\n", i + 1);
            }
            if (i <= 0) continue;
            char previousChar = content.charAt(i - 1);
            if ((c != ']' || previousChar == '[') && (c != '}' || previousChar == '{') || this._isAtLineStart(content, i)) continue;
            return StringUtil.insert(content, "\n", i);
        }
        return content;
    }

    private boolean _isAtLineStart(String content, int pos) {
        while (pos != 0) {
            char c = content.charAt(pos - 1);
            if (c == '\n') {
                return true;
            }
            if (!Character.isWhitespace(c)) {
                return false;
            }
            --pos;
        }
        return true;
    }
}

