/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.util.List;

public class BNDSuiteCheck
extends BaseFileCheck {
    private static final String _ALLOWED_FILE_NAMES_KEY = "allowedFileNames";
    private static final String[] _SUITES = new String[]{"collaboration", "forms-and-workflow", "foundation", "static", "web-experience"};

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String[] lines;
        if (!absolutePath.endsWith("/app.bnd")) {
            return content;
        }
        List<String> allowedFileNames = this.getAttributeValues(_ALLOWED_FILE_NAMES_KEY, absolutePath);
        for (String allowedFileName : allowedFileNames) {
            if (!absolutePath.endsWith(allowedFileName)) continue;
            return content;
        }
        if (content.matches("(?s).*Liferay-Releng-Deprecated:\\s*true.*")) {
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Suite", "");
        }
        for (String line : lines = StringUtil.splitLines(content)) {
            if (!line.contains("Liferay-Releng-Suite")) continue;
            String s = StringUtil.replace(line, "Liferay-Releng-Suite:", "");
            String value = StringUtil.toLowerCase(s.trim());
            if (Validator.isNull(value)) {
                content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Fix-Delivery-Method", "");
                content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Portal-Required", "false");
                continue;
            }
            if (!ArrayUtil.contains(_SUITES, value)) {
                String message = StringBundler.concat("The 'Liferay-Releng-Suite' can be blank or one of the ", "following values ", StringUtil.merge(_SUITES, ", "));
                this.addMessage(fileName, message);
                continue;
            }
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Bundle", "true");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Fix-Delivery-Method", "core");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Marketplace", "true");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Portal-Required", "true");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Suite", value);
        }
        if (!content.contains("Liferay-Releng-Suite:")) {
            content = content + "\nLiferay-Releng-Suite:";
        }
        return content;
    }
}

